/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.runtime.state.JavaSerializer;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.util.Preconditions;

@Internal
public final class StreamingFunctionUtils {
    public static <T> void setOutputType(Function userFunction, TypeInformation<T> outTypeInfo, ExecutionConfig executionConfig) {
        Preconditions.checkNotNull(outTypeInfo);
        Preconditions.checkNotNull(executionConfig);
        while (!StreamingFunctionUtils.trySetOutputType(userFunction, outTypeInfo, executionConfig) && userFunction instanceof WrappingFunction) {
            userFunction = ((WrappingFunction)userFunction).getWrappedFunction();
        }
    }

    private static <T> boolean trySetOutputType(Function userFunction, TypeInformation<T> outTypeInfo, ExecutionConfig executionConfig) {
        Preconditions.checkNotNull(outTypeInfo);
        Preconditions.checkNotNull(executionConfig);
        if (OutputTypeConfigurable.class.isAssignableFrom(userFunction.getClass())) {
            ((OutputTypeConfigurable)((Object)userFunction)).setOutputType(outTypeInfo, executionConfig);
            return true;
        }
        return false;
    }

    public static void snapshotFunctionState(StateSnapshotContext context, OperatorStateBackend backend, Function userFunction) throws Exception {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(backend);
        while (!StreamingFunctionUtils.trySnapshotFunctionState(context, backend, userFunction) && userFunction instanceof WrappingFunction) {
            userFunction = ((WrappingFunction)userFunction).getWrappedFunction();
        }
    }

    private static boolean trySnapshotFunctionState(StateSnapshotContext context, OperatorStateBackend backend, Function userFunction) throws Exception {
        if (userFunction instanceof CheckpointedFunction) {
            ((CheckpointedFunction)((Object)userFunction)).snapshotState(context);
            return true;
        }
        if (userFunction instanceof ListCheckpointed) {
            List partitionableState = ((ListCheckpointed)((Object)userFunction)).snapshotState(context.getCheckpointId(), context.getCheckpointTimestamp());
            ListStateDescriptor listStateDescriptor = new ListStateDescriptor("_default_", new JavaSerializer());
            ListState listState = backend.getListState(listStateDescriptor);
            listState.clear();
            if (null != partitionableState) {
                try {
                    for (Serializable statePartition : partitionableState) {
                        listState.add(statePartition);
                    }
                }
                catch (Exception e) {
                    listState.clear();
                    throw new Exception("Could not write partitionable state to operator state backend.", e);
                }
            }
            return true;
        }
        return false;
    }

    public static void restoreFunctionState(StateInitializationContext context, Function userFunction) throws Exception {
        Preconditions.checkNotNull(context);
        while (!StreamingFunctionUtils.tryRestoreFunction(context, userFunction) && userFunction instanceof WrappingFunction) {
            userFunction = ((WrappingFunction)userFunction).getWrappedFunction();
        }
    }

    private static boolean tryRestoreFunction(StateInitializationContext context, Function userFunction) throws Exception {
        if (userFunction instanceof CheckpointedFunction) {
            ((CheckpointedFunction)((Object)userFunction)).initializeState(context);
            return true;
        }
        if (context.isRestored() && userFunction instanceof ListCheckpointed) {
            ListCheckpointed listCheckpointedFun = (ListCheckpointed)((Object)userFunction);
            ListStateDescriptor listStateDescriptor = new ListStateDescriptor("_default_", new JavaSerializer());
            ListState listState = context.getOperatorStateStore().getListState(listStateDescriptor);
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            for (Serializable serializable : (Iterable)listState.get()) {
                list.add(serializable);
            }
            try {
                listCheckpointedFun.restoreState(list);
            }
            catch (Exception e) {
                throw new Exception("Failed to restore state to function: " + e.getMessage(), e);
            }
            return true;
        }
        return false;
    }

    private StreamingFunctionUtils() {
        throw new RuntimeException();
    }
}

