/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.transformations.TimestampsAndWatermarksTransformation;
import org.apache.flink.streaming.runtime.operators.TimestampsAndWatermarksOperator;
import org.apache.flink.streaming.runtime.translators.AbstractOneInputTransformationTranslator;
import org.apache.flink.util.Preconditions;

@Internal
public class TimestampsAndWatermarksTransformationTranslator<IN>
extends AbstractOneInputTransformationTranslator<IN, IN, TimestampsAndWatermarksTransformation<IN>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(TimestampsAndWatermarksTransformation<IN> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context, false);
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(TimestampsAndWatermarksTransformation<IN> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context, true);
    }

    private Collection<Integer> translateInternal(TimestampsAndWatermarksTransformation<IN> transformation, TransformationTranslator.Context context, boolean emitProgressiveWatermarks) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(context);
        TimestampsAndWatermarksOperator<IN> operator = new TimestampsAndWatermarksOperator<IN>(transformation.getWatermarkStrategy(), emitProgressiveWatermarks);
        SimpleOperatorFactory<IN> operatorFactory = SimpleOperatorFactory.of(operator);
        operatorFactory.setChainingStrategy(transformation.getChainingStrategy());
        return this.translateInternal(transformation, operatorFactory, transformation.getInputType(), null, null, context);
    }
}

