/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sorted.state;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.streaming.api.operators.sorted.state.MergingAbstractBatchExecutionKeyState;
import org.apache.flink.util.Preconditions;

class BatchExecutionKeyListState<K, N, T>
extends MergingAbstractBatchExecutionKeyState<K, N, List<T>, T, Iterable<T>>
implements InternalListState<K, N, T> {
    protected BatchExecutionKeyListState(List<T> defaultValue, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<List<T>> stateTypeSerializer) {
        super(defaultValue, keySerializer, namespaceSerializer, stateTypeSerializer);
    }

    @Override
    public void update(List<T> values) {
        Preconditions.checkNotNull(values);
        this.clear();
        for (T value : values) {
            this.add(value);
        }
    }

    @Override
    public void addAll(List<T> values) {
        if (Preconditions.checkNotNull(values).isEmpty()) {
            return;
        }
        for (T value : values) {
            this.add(value);
        }
    }

    @Override
    public void add(T value) {
        Preconditions.checkNotNull(value);
        this.initIfNull();
        ((List)this.getCurrentNamespaceValue()).add(value);
    }

    private void initIfNull() {
        if (this.getCurrentNamespaceValue() == null) {
            this.setCurrentNamespaceValue(new ArrayList());
        }
    }

    @Override
    public Iterable<T> get() throws Exception {
        return (Iterable)this.getCurrentNamespaceValue();
    }

    static <T, K, N, SV, S extends State, IS extends S> IS create(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, SV> stateDesc) {
        return (IS)new BatchExecutionKeyListState<K, N, T>((List)stateDesc.getDefaultValue(), keySerializer, namespaceSerializer, stateDesc.getSerializer());
    }

    @Override
    protected List<T> merge(List<T> target, List<T> source) {
        target.addAll(source);
        return target;
    }
}

