/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.io.Serializable;
import java.time.Duration;
import javax.annotation.Nonnegative;
import org.apache.flink.util.Preconditions;

public class ThreadInfoSamplesRequest
implements Serializable {
    private static final long serialVersionUID = -4360206136386773663L;
    private final int requestId;
    private final int numSubSamples;
    private final Duration delayBetweenSamples;
    private final int maxStackTraceDepth;

    public ThreadInfoSamplesRequest(int requestId, @Nonnegative int numSamples, Duration delayBetweenSamples, @Nonnegative int maxStackTraceDepth) {
        Preconditions.checkArgument(numSamples > 0, "numSamples must be positive");
        Preconditions.checkArgument(maxStackTraceDepth > 0, "maxStackTraceDepth must be positive");
        Preconditions.checkNotNull(delayBetweenSamples, "delayBetweenSamples must not be null");
        this.requestId = requestId;
        this.numSubSamples = numSamples;
        this.delayBetweenSamples = delayBetweenSamples;
        this.maxStackTraceDepth = maxStackTraceDepth;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getNumSamples() {
        return this.numSubSamples;
    }

    public Duration getDelayBetweenSamples() {
        return this.delayBetweenSamples;
    }

    public int getMaxStackTraceDepth() {
        return this.maxStackTraceDepth;
    }
}

