/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.Serializable;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.util.Preconditions;

public class UnresolvedTaskManagerLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ResourceID resourceID;
    private final String externalAddress;
    private final int dataPort;
    private final String nodeId;

    public UnresolvedTaskManagerLocation(ResourceID resourceID, String externalAddress, int dataPort, String nodeId) {
        Preconditions.checkArgument(dataPort > 0 || dataPort == -1, "dataPort must be > 0, or -1 (local)");
        this.resourceID = Preconditions.checkNotNull(resourceID);
        this.externalAddress = Preconditions.checkNotNull(externalAddress);
        this.dataPort = dataPort;
        this.nodeId = Preconditions.checkNotNull(nodeId);
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public String getExternalAddress() {
        return this.externalAddress;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public String getNodeId() {
        return this.nodeId;
    }
}

