/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.storage;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.ConfigurableCheckpointStorage;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageAccess;
import org.apache.flink.runtime.state.storage.ExternalizedSnapshotLocation;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class FileSystemCheckpointStorage
implements CheckpointStorage,
ConfigurableCheckpointStorage {
    private static final long serialVersionUID = -8191916350224044011L;
    private static final int MAX_FILE_STATE_THRESHOLD = 0x100000;
    private final ExternalizedSnapshotLocation location;
    private final int fileStateThreshold;
    private final int writeBufferSize;

    public FileSystemCheckpointStorage(String checkpointDirectory) {
        this(new Path(checkpointDirectory));
    }

    public FileSystemCheckpointStorage(Path checkpointDirectory) {
        this(checkpointDirectory, -1, -1);
    }

    public FileSystemCheckpointStorage(URI checkpointDirectory) {
        this(new Path(checkpointDirectory));
    }

    public FileSystemCheckpointStorage(URI checkpointDirectory, int fileStateSizeThreshold) {
        this(new Path(checkpointDirectory), fileStateSizeThreshold, -1);
    }

    public FileSystemCheckpointStorage(Path checkpointDirectory, int fileStateSizeThreshold, int writeBufferSize) {
        Preconditions.checkNotNull(checkpointDirectory, "checkpoint directory is null");
        Preconditions.checkArgument(fileStateSizeThreshold >= -1 && fileStateSizeThreshold <= 0x100000, "The threshold for file state size must be in [-1, %s], where '-1' means to use the value from the deployment's configuration.", 0x100000);
        Preconditions.checkArgument(writeBufferSize >= -1, "The write buffer size must be not less than '-1', where '-1' means to use the value from the deployment's configuration.");
        this.fileStateThreshold = fileStateSizeThreshold;
        this.writeBufferSize = writeBufferSize;
        this.location = ExternalizedSnapshotLocation.newBuilder().withCheckpointPath(checkpointDirectory).build();
    }

    private FileSystemCheckpointStorage(FileSystemCheckpointStorage original, ReadableConfig configuration) {
        if (this.getValidFileStateThreshold(original.fileStateThreshold) >= 0) {
            this.fileStateThreshold = original.fileStateThreshold;
        } else {
            int configuredStateThreshold = this.getValidFileStateThreshold(configuration.get(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD).getBytes());
            if (configuredStateThreshold >= 0) {
                this.fileStateThreshold = configuredStateThreshold;
            } else {
                this.fileStateThreshold = MathUtils.checkedDownCast(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue().getBytes());
                LoggerFactory.getLogger(FileSystemCheckpointStorage.class).warn("Ignoring invalid file size threshold value ({}): {} - using default value {} instead.", new Object[]{CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.key(), configuration.get(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD).getBytes(), CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue()});
            }
        }
        int bufferSize = original.writeBufferSize >= 0 ? original.writeBufferSize : configuration.get(CheckpointingOptions.FS_WRITE_BUFFER_SIZE);
        this.writeBufferSize = Math.max(bufferSize, this.fileStateThreshold);
        this.location = ExternalizedSnapshotLocation.newBuilder().withCheckpointPath(original.location.getBaseCheckpointPath()).withSavepointPath(original.location.getBaseSavepointPath()).withConfiguration(configuration).build();
    }

    private int getValidFileStateThreshold(long fileStateThreshold) {
        if (fileStateThreshold >= 0L && fileStateThreshold <= 0x100000L) {
            return (int)fileStateThreshold;
        }
        return -1;
    }

    @Override
    public FileSystemCheckpointStorage configure(ReadableConfig config, ClassLoader classLoader) throws IllegalConfigurationException {
        return new FileSystemCheckpointStorage(this, config);
    }

    public static FileSystemCheckpointStorage createFromConfig(ReadableConfig config, ClassLoader classLoader) throws IllegalConfigurationException {
        String checkpointDir = config.get(CheckpointingOptions.CHECKPOINTS_DIRECTORY);
        if (checkpointDir == null) {
            throw new IllegalConfigurationException("Cannot create the file system state backend: The configuration does not specify the checkpoint directory '" + CheckpointingOptions.CHECKPOINTS_DIRECTORY.key() + '\'');
        }
        try {
            return new FileSystemCheckpointStorage(checkpointDir).configure(config, classLoader);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalConfigurationException("Invalid configuration for the state backend", e);
        }
    }

    @Override
    public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
        return AbstractFsCheckpointStorageAccess.resolveCheckpointPointer(pointer);
    }

    @Override
    public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
        Preconditions.checkNotNull(jobId, "jobId");
        return new FsCheckpointStorageAccess(this.location.getBaseCheckpointPath(), this.location.getBaseSavepointPath(), jobId, this.getMinFileSizeThreshold(), this.getWriteBufferSize());
    }

    @Nonnull
    public Path getCheckpointPath() {
        return this.location.getBaseCheckpointPath();
    }

    @Nullable
    public Path getSavepointPath() {
        return this.location.getBaseSavepointPath();
    }

    public int getMinFileSizeThreshold() {
        return this.fileStateThreshold >= 0 ? this.fileStateThreshold : MathUtils.checkedDownCast(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue().getBytes());
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize >= 0 ? this.writeBufferSize : CheckpointingOptions.FS_WRITE_BUFFER_SIZE.defaultValue();
    }
}

