/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;

final class StateUID {
    @Nonnull
    private final String stateName;
    @Nonnull
    private final StateMetaInfoSnapshot.BackendStateType stateType;

    StateUID(@Nonnull String stateName, @Nonnull StateMetaInfoSnapshot.BackendStateType stateType) {
        this.stateName = stateName;
        this.stateType = stateType;
    }

    @Nonnull
    public String getStateName() {
        return this.stateName;
    }

    @Nonnull
    public StateMetaInfoSnapshot.BackendStateType getStateType() {
        return this.stateType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateUID uid = (StateUID)o;
        return Objects.equals(this.getStateName(), uid.getStateName()) && this.getStateType() == uid.getStateType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getStateName(), this.getStateType()});
    }

    public static StateUID of(@Nonnull String stateName, @Nonnull StateMetaInfoSnapshot.BackendStateType stateType) {
        return new StateUID(stateName, stateType);
    }
}

