/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.runtime.state.heap.AbstractHeapPriorityQueue;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;

public class HeapPriorityQueue<T extends HeapPriorityQueueElement>
extends AbstractHeapPriorityQueue<T> {
    private static final int QUEUE_HEAD_INDEX = 1;
    @Nonnull
    protected final PriorityComparator<T> elementPriorityComparator;

    public HeapPriorityQueue(@Nonnull PriorityComparator<T> elementPriorityComparator, @Nonnegative int minimumCapacity) {
        super(minimumCapacity);
        this.elementPriorityComparator = elementPriorityComparator;
    }

    public void adjustModifiedElement(@Nonnull T element) {
        int elementIndex = element.getInternalIndex();
        if (element == this.queue[elementIndex]) {
            this.adjustElementAtIndex(element, elementIndex);
        }
    }

    @Override
    protected int getHeadElementIndex() {
        return 1;
    }

    @Override
    protected void addInternal(@Nonnull T element) {
        int newSize = this.increaseSizeByOne();
        this.moveElementToIdx(element, newSize);
        this.siftUp(newSize);
    }

    @Override
    protected T removeInternal(int removeIdx) {
        HeapPriorityQueueElement[] heap = this.queue;
        HeapPriorityQueueElement removedValue = heap[removeIdx];
        assert (removedValue.getInternalIndex() == removeIdx);
        int oldSize = this.size;
        if (removeIdx != oldSize) {
            HeapPriorityQueueElement element = heap[oldSize];
            this.moveElementToIdx(element, removeIdx);
            this.adjustElementAtIndex(element, removeIdx);
        }
        heap[oldSize] = null;
        --this.size;
        return (T)removedValue;
    }

    private void adjustElementAtIndex(T element, int index) {
        this.siftDown(index);
        if (this.queue[index] == element) {
            this.siftUp(index);
        }
    }

    private void siftUp(int idx) {
        HeapPriorityQueueElement[] heap = this.queue;
        HeapPriorityQueueElement currentElement = heap[idx];
        for (int parentIdx = idx >>> 1; parentIdx > 0 && this.isElementPriorityLessThen(currentElement, heap[parentIdx]); parentIdx >>>= 1) {
            this.moveElementToIdx(heap[parentIdx], idx);
            idx = parentIdx;
        }
        this.moveElementToIdx(currentElement, idx);
    }

    private void siftDown(int idx) {
        HeapPriorityQueueElement[] heap = this.queue;
        int heapSize = this.size;
        HeapPriorityQueueElement currentElement = heap[idx];
        int firstChildIdx = idx << 1;
        int secondChildIdx = firstChildIdx + 1;
        if (this.isElementIndexValid(secondChildIdx, heapSize) && this.isElementPriorityLessThen(heap[secondChildIdx], heap[firstChildIdx])) {
            firstChildIdx = secondChildIdx;
        }
        while (this.isElementIndexValid(firstChildIdx, heapSize) && this.isElementPriorityLessThen(heap[firstChildIdx], currentElement)) {
            this.moveElementToIdx(heap[firstChildIdx], idx);
            idx = firstChildIdx;
            secondChildIdx = (firstChildIdx = idx << 1) + 1;
            if (!this.isElementIndexValid(secondChildIdx, heapSize) || !this.isElementPriorityLessThen(heap[secondChildIdx], heap[firstChildIdx])) continue;
            firstChildIdx = secondChildIdx;
        }
        this.moveElementToIdx(currentElement, idx);
    }

    private boolean isElementIndexValid(int elementIndex, int heapSize) {
        return elementIndex <= heapSize;
    }

    private boolean isElementPriorityLessThen(T a, T b) {
        return this.elementPriorityComparator.comparePriority(a, b) < 0;
    }

    private int increaseSizeByOne() {
        int minRequiredNewSize;
        int oldArraySize = this.queue.length;
        if ((minRequiredNewSize = ++this.size) >= oldArraySize) {
            int grow = oldArraySize < 64 ? oldArraySize + 2 : oldArraySize >> 1;
            this.resizeQueueArray(oldArraySize + grow, minRequiredNewSize);
        }
        return minRequiredNewSize;
    }
}

