/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredOperatorStateBackendMetaInfo<S>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final OperatorStateHandle.Mode assignmentMode;
    @Nonnull
    private final StateSerializerProvider<S> partitionStateSerializerProvider;

    public RegisteredOperatorStateBackendMetaInfo(@Nonnull String name, @Nonnull TypeSerializer<S> partitionStateSerializer, @Nonnull OperatorStateHandle.Mode assignmentMode) {
        this(name, StateSerializerProvider.fromNewRegisteredSerializer(partitionStateSerializer), assignmentMode);
    }

    private RegisteredOperatorStateBackendMetaInfo(@Nonnull RegisteredOperatorStateBackendMetaInfo<S> copy) {
        this(Preconditions.checkNotNull(copy).name, copy.getPartitionStateSerializer().duplicate(), copy.assignmentMode);
    }

    public RegisteredOperatorStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), StateSerializerProvider.fromPreviousSerializerSnapshot(Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER))), OperatorStateHandle.Mode.valueOf(snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.OPERATOR_STATE_DISTRIBUTION_MODE)));
        Preconditions.checkState(StateMetaInfoSnapshot.BackendStateType.OPERATOR == snapshot.getBackendStateType());
    }

    private RegisteredOperatorStateBackendMetaInfo(@Nonnull String name, @Nonnull StateSerializerProvider<S> partitionStateSerializerProvider, @Nonnull OperatorStateHandle.Mode assignmentMode) {
        super(name);
        this.partitionStateSerializerProvider = partitionStateSerializerProvider;
        this.assignmentMode = assignmentMode;
    }

    @Nonnull
    public RegisteredOperatorStateBackendMetaInfo<S> deepCopy() {
        return new RegisteredOperatorStateBackendMetaInfo<S>(this);
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Override
    @Nonnull
    public RegisteredOperatorStateBackendMetaInfo<S> withSerializerUpgradesAllowed() {
        return new RegisteredOperatorStateBackendMetaInfo<S>(this.snapshot());
    }

    @Nonnull
    public OperatorStateHandle.Mode getAssignmentMode() {
        return this.assignmentMode;
    }

    @Nonnull
    public TypeSerializer<S> getPartitionStateSerializer() {
        return this.partitionStateSerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<S> updatePartitionStateSerializer(TypeSerializer<S> newPartitionStateSerializer) {
        return this.partitionStateSerializerProvider.registerNewSerializerForRestoredState(newPartitionStateSerializer);
    }

    @Nullable
    public TypeSerializer<S> getPreviousPartitionStateSerializer() {
        return this.partitionStateSerializerProvider.previousSchemaSerializer();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof RegisteredOperatorStateBackendMetaInfo && this.name.equals(((RegisteredOperatorStateBackendMetaInfo)obj).getName()) && this.assignmentMode.equals((Object)((RegisteredOperatorStateBackendMetaInfo)obj).getAssignmentMode()) && this.getPartitionStateSerializer().equals(((RegisteredOperatorStateBackendMetaInfo)obj).getPartitionStateSerializer());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getAssignmentMode().hashCode();
        result = 31 * result + this.getPartitionStateSerializer().hashCode();
        return result;
    }

    public String toString() {
        return "RegisteredOperatorBackendStateMetaInfo{name='" + this.name + "', assignmentMode=" + (Object)((Object)this.assignmentMode) + ", partitionStateSerializer=" + this.getPartitionStateSerializer() + '}';
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.OPERATOR_STATE_DISTRIBUTION_MODE.toString(), this.assignmentMode.toString());
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        TypeSerializer<S> partitionStateSerializer = this.getPartitionStateSerializer();
        Map<String, TypeSerializer<?>> serializerMap = Collections.singletonMap(valueSerializerKey, partitionStateSerializer.duplicate());
        Map<String, TypeSerializerSnapshot<?>> serializerConfigSnapshotsMap = Collections.singletonMap(valueSerializerKey, partitionStateSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.OPERATOR, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }
}

