/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.net.InetSocketAddress;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.query.KvStateLocationRegistry;
import org.apache.flink.runtime.query.UnknownKvStateLocation;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvStateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KvStateHandler.class);
    private final ExecutionGraph executionGraph;

    public KvStateHandler(ExecutionGraph executionGraph) {
        this.executionGraph = executionGraph;
    }

    public KvStateLocation requestKvStateLocation(JobID jobId, String registrationName) throws UnknownKvStateLocation, FlinkJobNotFoundException {
        if (this.executionGraph.getJobID().equals(jobId)) {
            KvStateLocationRegistry registry;
            KvStateLocation location;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lookup key-value state for job {} with registration name {}.", (Object)this.executionGraph.getJobID(), (Object)registrationName);
            }
            if ((location = (registry = this.executionGraph.getKvStateLocationRegistry()).getKvStateLocation(registrationName)) != null) {
                return location;
            }
            throw new UnknownKvStateLocation(registrationName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request of key-value state location for unknown job {} received.", (Object)jobId);
        }
        throw new FlinkJobNotFoundException(jobId);
    }

    public void notifyKvStateRegistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId, InetSocketAddress kvStateServerAddress) throws FlinkJobNotFoundException {
        if (this.executionGraph.getJobID().equals(jobId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key value state registered for job {} under name {}.", (Object)this.executionGraph.getJobID(), (Object)registrationName);
            }
            try {
                this.executionGraph.getKvStateLocationRegistry().notifyKvStateRegistered(jobVertexId, keyGroupRange, registrationName, kvStateId, kvStateServerAddress);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new FlinkJobNotFoundException(jobId);
        }
    }

    public void notifyKvStateUnregistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) throws FlinkJobNotFoundException {
        if (this.executionGraph.getJobID().equals(jobId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key value state unregistered for job {} under name {}.", (Object)this.executionGraph.getJobID(), (Object)registrationName);
            }
            try {
                this.executionGraph.getKvStateLocationRegistry().notifyKvStateUnregistered(jobVertexId, keyGroupRange, registrationName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new FlinkJobNotFoundException(jobId);
        }
    }
}

