/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.Serializable;
import java.util.UUID;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class TaskManagerRegistrationInformation
implements Serializable {
    private static final long serialVersionUID = 1767026305134276540L;
    private final String taskManagerRpcAddress;
    private final UnresolvedTaskManagerLocation unresolvedTaskManagerLocation;
    private final UUID taskManagerSession;

    private TaskManagerRegistrationInformation(String taskManagerRpcAddress, UnresolvedTaskManagerLocation unresolvedTaskManagerLocation, UUID taskManagerSession) {
        this.taskManagerRpcAddress = Preconditions.checkNotNull(taskManagerRpcAddress);
        this.unresolvedTaskManagerLocation = Preconditions.checkNotNull(unresolvedTaskManagerLocation);
        this.taskManagerSession = Preconditions.checkNotNull(taskManagerSession);
    }

    public String getTaskManagerRpcAddress() {
        return this.taskManagerRpcAddress;
    }

    public UnresolvedTaskManagerLocation getUnresolvedTaskManagerLocation() {
        return this.unresolvedTaskManagerLocation;
    }

    public UUID getTaskManagerSession() {
        return this.taskManagerSession;
    }

    public static TaskManagerRegistrationInformation create(String taskManagerRpcAddress, UnresolvedTaskManagerLocation unresolvedTaskManagerLocation, UUID taskManagerSession) {
        return new TaskManagerRegistrationInformation(taskManagerRpcAddress, unresolvedTaskManagerLocation, taskManagerSession);
    }
}

