/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalEdge;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResult;
import org.apache.flink.runtime.jobgraph.topology.LogicalEdge;
import org.apache.flink.runtime.jobgraph.topology.LogicalVertex;
import org.apache.flink.util.Preconditions;

public class DefaultLogicalVertex
implements LogicalVertex {
    private final JobVertex jobVertex;
    private final Function<IntermediateDataSetID, DefaultLogicalResult> resultRetriever;
    private final List<LogicalEdge> inputEdges;

    DefaultLogicalVertex(JobVertex jobVertex, Function<IntermediateDataSetID, DefaultLogicalResult> resultRetriever) {
        this.jobVertex = Preconditions.checkNotNull(jobVertex);
        this.resultRetriever = Preconditions.checkNotNull(resultRetriever);
        this.inputEdges = jobVertex.getInputs().stream().map(DefaultLogicalEdge::new).collect(Collectors.toList());
    }

    @Override
    public JobVertexID getId() {
        return this.jobVertex.getID();
    }

    @Override
    public Iterable<DefaultLogicalResult> getConsumedResults() {
        return this.jobVertex.getInputs().stream().map(JobEdge::getSource).map(IntermediateDataSet::getId).map(this.resultRetriever).collect(Collectors.toList());
    }

    @Override
    public Iterable<DefaultLogicalResult> getProducedResults() {
        return this.jobVertex.getProducedDataSets().stream().map(IntermediateDataSet::getId).map(this.resultRetriever).collect(Collectors.toList());
    }

    @Override
    public Iterable<? extends LogicalEdge> getInputs() {
        return this.inputEdges;
    }
}

