/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.topology.LogicalPipelinedRegion;
import org.apache.flink.runtime.jobgraph.topology.LogicalVertex;
import org.apache.flink.runtime.topology.Vertex;
import org.apache.flink.util.Preconditions;

public class DefaultLogicalPipelinedRegion
implements LogicalPipelinedRegion {
    private final Map<JobVertexID, LogicalVertex> vertexById;

    public DefaultLogicalPipelinedRegion(Set<? extends LogicalVertex> logicalVertices) {
        Preconditions.checkNotNull(logicalVertices);
        this.vertexById = logicalVertices.stream().collect(Collectors.toMap(Vertex::getId, Function.identity()));
    }

    @Override
    public Iterable<? extends LogicalVertex> getVertices() {
        return this.vertexById.values();
    }

    @Override
    public LogicalVertex getVertex(JobVertexID vertexId) {
        return this.vertexById.get(vertexId);
    }

    @Override
    public boolean contains(JobVertexID vertexId) {
        return this.vertexById.containsKey(vertexId);
    }

    public String toString() {
        return "DefaultLogicalPipelinedRegion{vertexIDs=" + this.vertexById.values().stream().map(Vertex::getId).collect(Collectors.toList()) + '}';
    }
}

