/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.NetworkClientHandler;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.util.Preconditions;

class NetworkBufferAllocator {
    private final NetworkClientHandler networkClientHandler;

    NetworkBufferAllocator(NetworkClientHandler networkClientHandler) {
        this.networkClientHandler = Preconditions.checkNotNull(networkClientHandler);
    }

    @Nullable
    Buffer allocatePooledNetworkBuffer(InputChannelID receiverId) {
        Buffer buffer = null;
        RemoteInputChannel inputChannel = this.networkClientHandler.getInputChannel(receiverId);
        if (inputChannel != null) {
            buffer = inputChannel.requestBuffer();
        }
        return buffer;
    }

    Buffer allocateUnPooledNetworkBuffer(int size, Buffer.DataType dataType) {
        Preconditions.checkArgument(size > 0, "Illegal buffer size, must be positive.");
        byte[] byteArray = new byte[size];
        MemorySegment memSeg = MemorySegmentFactory.wrap(byteArray);
        return new NetworkBuffer(memSeg, FreeingBufferRecycler.INSTANCE, dataType);
    }
}

