/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.function.FunctionUtils;

final class SegmentWriteRequest
implements WriteRequest {
    private final AsynchronousFileIOChannel<MemorySegment, WriteRequest> channel;
    private final MemorySegment segment;

    protected SegmentWriteRequest(AsynchronousFileIOChannel<MemorySegment, WriteRequest> targetChannel, MemorySegment segment) {
        this.channel = targetChannel;
        this.segment = segment;
    }

    @Override
    public void write() throws IOException {
        try {
            this.segment.processAsByteBuffer(FunctionUtils.uncheckedConsumer(buffer -> FileUtils.writeCompletely(this.channel.fileChannel, buffer)));
        }
        catch (NullPointerException npex) {
            throw new IOException("Memory segment has been released.");
        }
    }

    @Override
    public void requestDone(IOException ioex) {
        this.channel.handleProcessedBuffer(this.segment, ioex);
    }
}

