/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.LocatedHadoopFileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;

public class HadoopFileStatus
implements FileStatus {
    private final org.apache.hadoop.fs.FileStatus fileStatus;

    public HadoopFileStatus(org.apache.hadoop.fs.FileStatus fileStatus) {
        this.fileStatus = fileStatus;
    }

    @Override
    public long getLen() {
        return this.fileStatus.getLen();
    }

    @Override
    public long getBlockSize() {
        return Math.min(this.fileStatus.getBlockSize(), this.fileStatus.getLen());
    }

    @Override
    public long getAccessTime() {
        return this.fileStatus.getAccessTime();
    }

    @Override
    public long getModificationTime() {
        return this.fileStatus.getModificationTime();
    }

    @Override
    public short getReplication() {
        return this.fileStatus.getReplication();
    }

    @Override
    public Path getPath() {
        return new Path(this.fileStatus.getPath().toUri());
    }

    @Override
    public boolean isDir() {
        return this.fileStatus.isDirectory();
    }

    public org.apache.hadoop.fs.FileStatus getInternalFileStatus() {
        return this.fileStatus;
    }

    public static HadoopFileStatus fromHadoopStatus(org.apache.hadoop.fs.FileStatus fileStatus) {
        return fileStatus instanceof LocatedFileStatus ? new LocatedHadoopFileStatus((LocatedFileStatus)fileStatus) : new HadoopFileStatus(fileStatus);
    }
}

