/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;

class AllVerticesIterator<EV extends AccessExecutionVertex, EJV extends AccessExecutionJobVertex>
implements Iterator<EV> {
    private final Iterator<EJV> jobVertices;
    private EV[] currVertices;
    private int currPos;

    public AllVerticesIterator(Iterator<EJV> jobVertices) {
        this.jobVertices = jobVertices;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.currVertices != null) {
                if (this.currPos < this.currVertices.length) {
                    return true;
                }
                this.currVertices = null;
                continue;
            }
            if (!this.jobVertices.hasNext()) break;
            this.currVertices = ((AccessExecutionJobVertex)this.jobVertices.next()).getTaskVertices();
            this.currPos = 0;
        }
        return false;
    }

    @Override
    public EV next() {
        if (this.hasNext()) {
            return this.currVertices[this.currPos++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

