/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.OutputStream;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.util.Preconditions;

@Internal
public class ByteArrayOutputStreamWithPos
extends OutputStream {
    protected byte[] buffer;
    protected int count;

    public ByteArrayOutputStreamWithPos() {
        this(64);
    }

    public ByteArrayOutputStreamWithPos(int size) {
        Preconditions.checkArgument(size >= 0);
        this.buffer = new byte[size];
    }

    private void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity - this.buffer.length > 0) {
            this.increaseCapacity(requiredCapacity);
        }
    }

    private void increaseCapacity(int requiredCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - requiredCapacity < 0) {
            newCapacity = requiredCapacity;
        }
        if (newCapacity < 0) {
            if (requiredCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off > b.length || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buffer, this.count);
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count, ConfigConstants.DEFAULT_CHARSET);
    }

    public int getPosition() {
        return this.count;
    }

    public void setPosition(int position) {
        Preconditions.checkArgument(position >= 0, "Position out of bounds.");
        this.ensureCapacity(position + 1);
        this.count = position;
    }

    @Override
    public void close() {
    }

    public byte[] getBuf() {
        return this.buffer;
    }
}

