/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.table.MetastoreCommitPolicy;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.connector.file.table.SuccessFileCommitPolicy;
import org.apache.flink.core.fs.FileSystem;

@Internal
public class PartitionCommitPolicyFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String policyKind;
    private final String customClass;
    private final String successFileName;

    public PartitionCommitPolicyFactory(String policyKind, String customClass, String successFileName) {
        this.policyKind = policyKind;
        this.customClass = customClass;
        this.successFileName = successFileName;
    }

    public List<PartitionCommitPolicy> createPolicyChain(ClassLoader cl, Supplier<FileSystem> fsSupplier) {
        if (this.policyKind == null) {
            return Collections.emptyList();
        }
        String[] policyStrings = this.policyKind.split(",");
        return Arrays.stream(policyStrings).map(name -> {
            switch (name.toLowerCase()) {
                case "metastore": {
                    return new MetastoreCommitPolicy();
                }
                case "success-file": {
                    return new SuccessFileCommitPolicy(this.successFileName, (FileSystem)fsSupplier.get());
                }
                case "custom": {
                    try {
                        return (PartitionCommitPolicy)cl.loadClass(this.customClass).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException("Can not create new instance for custom class from " + this.customClass, e);
                    }
                }
            }
            throw new UnsupportedOperationException("Unsupported policy: " + name);
        }).collect(Collectors.toList());
    }
}

