/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
public class FileSinkCommittableSerializer
implements SimpleVersionedSerializer<FileSinkCommittable> {
    private static final int MAGIC_NUMBER = 511073408;
    private final SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> pendingFileSerializer;
    private final SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable> inProgressFileSerializer;

    public FileSinkCommittableSerializer(SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> pendingFileSerializer, SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable> inProgressFileSerializer) {
        this.pendingFileSerializer = Preconditions.checkNotNull(pendingFileSerializer);
        this.inProgressFileSerializer = Preconditions.checkNotNull(inProgressFileSerializer);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public byte[] serialize(FileSinkCommittable committable) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(256);
        out.writeInt(511073408);
        this.serializeV2(committable, out);
        return out.getCopyOfBuffer();
    }

    @Override
    public FileSinkCommittable deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        switch (version) {
            case 1: {
                FileSinkCommittableSerializer.validateMagicNumber(in);
                return this.deserializeV1(in);
            }
            case 2: {
                FileSinkCommittableSerializer.validateMagicNumber(in);
                return this.deserializeV2(in);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private void serializeV2(FileSinkCommittable committable, DataOutputView dataOutputView) throws IOException {
        dataOutputView.writeUTF(committable.getBucketId());
        if (committable.hasPendingFile()) {
            dataOutputView.writeBoolean(true);
            SimpleVersionedSerialization.writeVersionAndSerialize(this.pendingFileSerializer, committable.getPendingFile(), dataOutputView);
        } else {
            dataOutputView.writeBoolean(false);
        }
        if (committable.hasInProgressFileToCleanup()) {
            dataOutputView.writeBoolean(true);
            SimpleVersionedSerialization.writeVersionAndSerialize(this.inProgressFileSerializer, committable.getInProgressFileToCleanup(), dataOutputView);
        } else {
            dataOutputView.writeBoolean(false);
        }
        if (committable.hasCompactedFileToCleanup()) {
            dataOutputView.writeBoolean(true);
            dataOutputView.writeUTF(committable.getCompactedFileToCleanup().toUri().toString());
        } else {
            dataOutputView.writeBoolean(false);
        }
    }

    private FileSinkCommittable deserializeV1(DataInputView dataInputView) throws IOException {
        InProgressFileWriter.PendingFileRecoverable pendingFile = null;
        if (dataInputView.readBoolean()) {
            pendingFile = SimpleVersionedSerialization.readVersionAndDeSerialize(this.pendingFileSerializer, dataInputView);
        }
        InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup = null;
        if (dataInputView.readBoolean()) {
            inProgressFileToCleanup = SimpleVersionedSerialization.readVersionAndDeSerialize(this.inProgressFileSerializer, dataInputView);
        }
        return new FileSinkCommittable("", pendingFile, inProgressFileToCleanup, null);
    }

    private FileSinkCommittable deserializeV2(DataInputView dataInputView) throws IOException {
        String bucketId = dataInputView.readUTF();
        InProgressFileWriter.PendingFileRecoverable pendingFile = null;
        if (dataInputView.readBoolean()) {
            pendingFile = SimpleVersionedSerialization.readVersionAndDeSerialize(this.pendingFileSerializer, dataInputView);
        }
        InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup = null;
        if (dataInputView.readBoolean()) {
            inProgressFileToCleanup = SimpleVersionedSerialization.readVersionAndDeSerialize(this.inProgressFileSerializer, dataInputView);
        }
        Path committedFileToCleanup = null;
        if (dataInputView.readBoolean()) {
            committedFileToCleanup = new Path(dataInputView.readUTF());
        }
        return new FileSinkCommittable(bucketId, pendingFile, inProgressFileToCleanup, committedFileToCleanup);
    }

    private static void validateMagicNumber(DataInputView in) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != 511073408) {
            throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", magicNumber));
        }
    }
}

