/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.table;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.table.AsyncSinkConnectorOptions;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSinkBuilder;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;

@PublicEvolving
public abstract class AsyncDynamicTableSinkFactory
implements DynamicTableSinkFactory {
    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(AsyncSinkConnectorOptions.MAX_BATCH_SIZE);
        options.add(AsyncSinkConnectorOptions.FLUSH_BUFFER_SIZE);
        options.add(AsyncSinkConnectorOptions.MAX_BUFFERED_REQUESTS);
        options.add(AsyncSinkConnectorOptions.FLUSH_BUFFER_TIMEOUT);
        options.add(AsyncSinkConnectorOptions.MAX_IN_FLIGHT_REQUESTS);
        return options;
    }

    protected AsyncDynamicTableSinkBuilder<?, ?> addAsyncOptionsToBuilder(Properties configuration, AsyncDynamicTableSinkBuilder<?, ?> builder) {
        Optional.ofNullable((Long)configuration.get(AsyncSinkConnectorOptions.FLUSH_BUFFER_SIZE.key())).ifPresent(builder::setMaxBufferSizeInBytes);
        Optional.ofNullable((Long)configuration.get(AsyncSinkConnectorOptions.FLUSH_BUFFER_TIMEOUT.key())).ifPresent(builder::setMaxTimeInBufferMS);
        Optional.ofNullable((Integer)configuration.get(AsyncSinkConnectorOptions.MAX_BATCH_SIZE.key())).ifPresent(builder::setMaxBatchSize);
        Optional.ofNullable((Integer)configuration.get(AsyncSinkConnectorOptions.MAX_BUFFERED_REQUESTS.key())).ifPresent(builder::setMaxBufferedRequests);
        Optional.ofNullable((Integer)configuration.get(AsyncSinkConnectorOptions.MAX_IN_FLIGHT_REQUESTS.key())).ifPresent(builder::setMaxInFlightRequests);
        return builder;
    }

    @Internal
    public class AsyncDynamicSinkContext {
        private final ReadableConfig tableOptions;
        private final DataType physicalDataType;
        private final FactoryUtil.TableFactoryHelper helper;
        private final EncodingFormat<SerializationSchema<RowData>> encodingFormat;
        private final Map<String, String> resolvedOptions;
        private final List<String> partitionKeys;
        private final boolean isPartitioned;

        public AsyncDynamicSinkContext(AsyncDynamicTableSinkFactory factory, DynamicTableFactory.Context context) {
            this.helper = FactoryUtil.createTableFactoryHelper(factory, context);
            this.tableOptions = this.helper.getOptions();
            ResolvedCatalogTable catalogTable = context.getCatalogTable();
            this.resolvedOptions = catalogTable.getOptions();
            this.physicalDataType = catalogTable.getResolvedSchema().toPhysicalRowDataType();
            this.encodingFormat = this.helper.discoverEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT);
            this.partitionKeys = catalogTable.getPartitionKeys();
            this.isPartitioned = catalogTable.isPartitioned();
        }

        public ReadableConfig getTableOptions() {
            return this.tableOptions;
        }

        public DataType getPhysicalDataType() {
            return this.physicalDataType;
        }

        public FactoryUtil.TableFactoryHelper getFactoryHelper() {
            return this.helper;
        }

        public Map<String, String> getResolvedOptions() {
            return this.resolvedOptions;
        }

        public EncodingFormat<SerializationSchema<RowData>> getEncodingFormat() {
            return this.encodingFormat;
        }

        public List<String> getPartitionKeys() {
            return this.partitionKeys;
        }

        public boolean isPartitioned() {
            return this.isPartitioned;
        }
    }
}

