/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;

@Internal
public class GzipInflaterInputStreamFactory
implements InflaterInputStreamFactory<GZIPInputStream> {
    private static final GzipInflaterInputStreamFactory INSTANCE = new GzipInflaterInputStreamFactory();

    public static GzipInflaterInputStreamFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public GZIPInputStream create(InputStream in) throws IOException {
        return new GZIPInputStream(in);
    }

    @Override
    public Collection<String> getCommonFileExtensions() {
        return Arrays.asList("gz", "gzip");
    }
}

