/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.io.FilePathFilter;
import org.apache.flink.api.common.io.GlobFilePathFilter;
import org.apache.flink.api.common.io.InputStreamFSInputWrapper;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.compression.Bzip2InputStreamFactory;
import org.apache.flink.api.common.io.compression.DeflateInflaterInputStreamFactory;
import org.apache.flink.api.common.io.compression.GzipInflaterInputStreamFactory;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;
import org.apache.flink.api.common.io.compression.XZInputStreamFactory;
import org.apache.flink.api.common.io.compression.ZStandardInputStreamFactory;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class FileInputFormat<OT>
extends RichInputFormat<OT, FileInputSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(FileInputFormat.class);
    private static final long serialVersionUID = 1L;
    private static final float MAX_SPLIT_SIZE_DISCREPANCY = 1.1f;
    private static long DEFAULT_OPENING_TIMEOUT;
    protected static final Map<String, InflaterInputStreamFactory<?>> INFLATER_INPUT_STREAM_FACTORIES;
    protected static final long READ_WHOLE_SPLIT_FLAG = -1L;
    protected transient FSDataInputStream stream;
    protected transient long splitStart;
    protected transient long splitLength;
    protected transient FileInputSplit currentSplit;
    @Deprecated
    protected Path filePath;
    private Path[] filePaths;
    protected long minSplitSize = 0L;
    protected int numSplits = -1;
    protected long openTimeout = DEFAULT_OPENING_TIMEOUT;
    protected boolean unsplittable = false;
    protected boolean enumerateNestedFiles = false;
    private FilePathFilter filesFilter = new GlobFilePathFilter();
    private static final String FILE_PARAMETER_KEY = "input.file.path";
    public static final String ENUMERATE_NESTED_FILES_FLAG = "recursive.file.enumeration";

    private static void initDefaultsFromConfiguration(Configuration configuration) {
        long to = configuration.getLong("taskmanager.runtime.fs_timeout", 0L);
        if (to < 0L) {
            LOG.error("Invalid timeout value for filesystem stream opening: " + to + ". Using default value of " + 0);
            DEFAULT_OPENING_TIMEOUT = 0L;
        } else {
            DEFAULT_OPENING_TIMEOUT = to == 0L ? 300000L : to;
        }
    }

    private static void initDefaultInflaterInputStreamFactories() {
        InflaterInputStreamFactory[] defaultFactories;
        for (InflaterInputStreamFactory inputStreamFactory : defaultFactories = new InflaterInputStreamFactory[]{DeflateInflaterInputStreamFactory.getInstance(), GzipInflaterInputStreamFactory.getInstance(), Bzip2InputStreamFactory.getInstance(), XZInputStreamFactory.getInstance(), ZStandardInputStreamFactory.getInstance()}) {
            for (String fileExtension : inputStreamFactory.getCommonFileExtensions()) {
                FileInputFormat.registerInflaterInputStreamFactory(fileExtension, inputStreamFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInflaterInputStreamFactory(String fileExtension, InflaterInputStreamFactory<?> factory) {
        Map<String, InflaterInputStreamFactory<?>> map = INFLATER_INPUT_STREAM_FACTORIES;
        synchronized (map) {
            if (INFLATER_INPUT_STREAM_FACTORIES.put(fileExtension, factory) != null) {
                LOG.warn("Overwriting an existing decompression algorithm for \"{}\" files.", (Object)fileExtension);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static InflaterInputStreamFactory<?> getInflaterInputStreamFactory(String fileExtension) {
        Map<String, InflaterInputStreamFactory<?>> map = INFLATER_INPUT_STREAM_FACTORIES;
        synchronized (map) {
            return INFLATER_INPUT_STREAM_FACTORIES.get(fileExtension);
        }
    }

    protected static String extractFileExtension(String fileName) {
        Preconditions.checkNotNull(fileName);
        int lastPeriodIndex = fileName.lastIndexOf(46);
        if (lastPeriodIndex < 0) {
            return null;
        }
        return fileName.substring(lastPeriodIndex + 1);
    }

    public FileInputFormat() {
    }

    protected FileInputFormat(Path filePath) {
        if (filePath != null) {
            this.setFilePath(filePath);
        }
    }

    @Deprecated
    public Path getFilePath() {
        if (this.supportsMultiPaths()) {
            if (this.filePaths == null || this.filePaths.length == 0) {
                return null;
            }
            if (this.filePaths.length == 1) {
                return this.filePaths[0];
            }
            throw new UnsupportedOperationException("FileInputFormat is configured with multiple paths. Use getFilePaths() instead.");
        }
        return this.filePath;
    }

    public Path[] getFilePaths() {
        if (this.supportsMultiPaths()) {
            if (this.filePaths == null) {
                return new Path[0];
            }
            return this.filePaths;
        }
        if (this.filePath == null) {
            return new Path[0];
        }
        return new Path[]{this.filePath};
    }

    public void setFilePath(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("File path cannot be null.");
        }
        if (filePath.isEmpty()) {
            this.setFilePath(new Path());
            return;
        }
        try {
            this.setFilePath(new Path(filePath));
        }
        catch (RuntimeException rex) {
            throw new RuntimeException("Could not create a valid URI from the given file path name: " + rex.getMessage());
        }
    }

    public void setFilePath(Path filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("File path must not be null.");
        }
        this.setFilePaths(filePath);
    }

    public void setFilePaths(String ... filePaths) {
        Path[] paths = new Path[filePaths.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = new Path(filePaths[i]);
        }
        this.setFilePaths(paths);
    }

    public void setFilePaths(Path ... filePaths) {
        if (!this.supportsMultiPaths() && filePaths.length > 1) {
            throw new UnsupportedOperationException("Multiple paths are not supported by this FileInputFormat.");
        }
        if (filePaths.length < 1) {
            throw new IllegalArgumentException("At least one file path must be specified.");
        }
        this.filePath = filePaths.length == 1 ? filePaths[0] : null;
        this.filePaths = filePaths;
    }

    public long getMinSplitSize() {
        return this.minSplitSize;
    }

    public void setMinSplitSize(long minSplitSize) {
        if (minSplitSize < 0L) {
            throw new IllegalArgumentException("The minimum split size cannot be negative.");
        }
        this.minSplitSize = minSplitSize;
    }

    public int getNumSplits() {
        return this.numSplits;
    }

    public void setNumSplits(int numSplits) {
        if (numSplits < -1 || numSplits == 0) {
            throw new IllegalArgumentException("The desired number of splits must be positive or -1 (= don't care).");
        }
        this.numSplits = numSplits;
    }

    public long getOpenTimeout() {
        return this.openTimeout;
    }

    public void setOpenTimeout(long openTimeout) {
        if (openTimeout < 0L) {
            throw new IllegalArgumentException("The timeout for opening the input splits must be positive or zero (= infinite).");
        }
        this.openTimeout = openTimeout;
    }

    public void setNestedFileEnumeration(boolean enable) {
        this.enumerateNestedFiles = enable;
    }

    public boolean getNestedFileEnumeration() {
        return this.enumerateNestedFiles;
    }

    public long getSplitStart() {
        return this.splitStart;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    public void setFilesFilter(FilePathFilter filesFilter) {
        this.filesFilter = Preconditions.checkNotNull(filesFilter, "Files filter should not be null");
    }

    @Override
    public void configure(Configuration parameters) {
        if (this.getFilePaths().length == 0) {
            String filePath = parameters.getString(FILE_PARAMETER_KEY, null);
            if (filePath == null) {
                throw new IllegalArgumentException("File path was not specified in input format or configuration.");
            }
            this.setFilePath(filePath);
        }
        if (!this.enumerateNestedFiles) {
            this.enumerateNestedFiles = parameters.getBoolean(ENUMERATE_NESTED_FILES_FLAG, false);
        }
    }

    @Override
    public FileBaseStatistics getStatistics(BaseStatistics cachedStats) throws IOException {
        block4: {
            FileBaseStatistics cachedFileStats = cachedStats instanceof FileBaseStatistics ? (FileBaseStatistics)cachedStats : null;
            try {
                return this.getFileStats(cachedFileStats, this.getFilePaths(), new ArrayList<FileStatus>(this.getFilePaths().length));
            }
            catch (IOException ioex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Could not determine statistics for paths '" + Arrays.toString(this.getFilePaths()) + "' due to an io error: " + ioex.getMessage());
                }
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("Unexpected problem while getting the file statistics for paths '" + Arrays.toString(this.getFilePaths()) + "': " + t.getMessage(), t);
            }
        }
        return null;
    }

    protected FileBaseStatistics getFileStats(FileBaseStatistics cachedStats, Path[] filePaths, ArrayList<FileStatus> files) throws IOException {
        long totalLength = 0L;
        long latestModTime = 0L;
        for (Path path : filePaths) {
            FileSystem fs = FileSystem.get(path.toUri());
            FileBaseStatistics stats = this.getFileStats(cachedStats, path, fs, files);
            if (stats.getTotalInputSize() == -1L) {
                totalLength = -1L;
            } else if (totalLength != -1L) {
                totalLength += stats.getTotalInputSize();
            }
            latestModTime = Math.max(latestModTime, stats.getLastModificationTime());
        }
        if (cachedStats != null && latestModTime <= cachedStats.getLastModificationTime()) {
            return cachedStats;
        }
        return new FileBaseStatistics(latestModTime, totalLength, -1.0f);
    }

    protected FileBaseStatistics getFileStats(FileBaseStatistics cachedStats, Path filePath, FileSystem fs, ArrayList<FileStatus> files) throws IOException {
        FileStatus file = fs.getFileStatus(filePath);
        long totalLength = 0L;
        if (file.isDir()) {
            totalLength += this.addFilesInDir(file.getPath(), files, false);
        } else {
            files.add(file);
            this.testForUnsplittable(file);
            totalLength += file.getLen();
        }
        long latestModTime = 0L;
        for (FileStatus f : files) {
            latestModTime = Math.max(f.getModificationTime(), latestModTime);
        }
        if (cachedStats != null && latestModTime <= cachedStats.getLastModificationTime()) {
            return cachedStats;
        }
        if (totalLength <= 0L) {
            totalLength = -1L;
        }
        return new FileBaseStatistics(latestModTime, totalLength, -1.0f);
    }

    public LocatableInputSplitAssigner getInputSplitAssigner(FileInputSplit[] splits) {
        return new LocatableInputSplitAssigner(splits);
    }

    public FileInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        if (minNumSplits < 1) {
            throw new IllegalArgumentException("Number of input splits has to be at least 1.");
        }
        minNumSplits = Math.max(minNumSplits, this.numSplits);
        ArrayList<FileInputSplit> inputSplits = new ArrayList<FileInputSplit>(minNumSplits);
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        long totalLength = 0L;
        for (Path path : this.getFilePaths()) {
            FileSystem fs = path.getFileSystem();
            FileStatus pathFile = fs.getFileStatus(path);
            if (pathFile.isDir()) {
                totalLength += this.addFilesInDir(path, files, true);
                continue;
            }
            this.testForUnsplittable(pathFile);
            files.add(pathFile);
            totalLength += pathFile.getLen();
        }
        if (this.unsplittable) {
            int splitNum = 0;
            for (FileStatus file : files) {
                FileSystem fs = file.getPath().getFileSystem();
                BlockLocation[] blocks = fs.getFileBlockLocations(file, 0L, file.getLen());
                HashSet<String> hosts = new HashSet<String>();
                for (BlockLocation block : blocks) {
                    hosts.addAll(Arrays.asList(block.getHosts()));
                }
                long len = file.getLen();
                if (this.testForUnsplittable(file)) {
                    len = -1L;
                }
                FileInputSplit fis = new FileInputSplit(splitNum++, file.getPath(), 0L, len, hosts.toArray(new String[hosts.size()]));
                inputSplits.add(fis);
            }
            return inputSplits.toArray(new FileInputSplit[inputSplits.size()]);
        }
        long maxSplitSize = totalLength / (long)minNumSplits + (long)(totalLength % (long)minNumSplits == 0L ? 0 : 1);
        int splitNum = 0;
        for (FileStatus file : files) {
            Object[] blocks;
            long minSplitSize;
            FileSystem fs = file.getPath().getFileSystem();
            long len = file.getLen();
            long blockSize = file.getBlockSize();
            if (this.minSplitSize <= blockSize) {
                minSplitSize = this.minSplitSize;
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Minimal split size of " + this.minSplitSize + " is larger than the block size of " + blockSize + ". Decreasing minimal split size to block size.");
                }
                minSplitSize = blockSize;
            }
            long splitSize = Math.max(minSplitSize, Math.min(maxSplitSize, blockSize));
            long halfSplit = splitSize >>> 1;
            long maxBytesForLastSplit = (long)((float)splitSize * 1.1f);
            if (len > 0L) {
                FileInputSplit fis;
                long bytesUnassigned;
                blocks = fs.getFileBlockLocations(file, 0L, len);
                Arrays.sort(blocks);
                long position = 0L;
                int blockIndex = 0;
                for (bytesUnassigned = len; bytesUnassigned > maxBytesForLastSplit; bytesUnassigned -= splitSize) {
                    blockIndex = this.getBlockIndexForPosition((BlockLocation[])blocks, position, halfSplit, blockIndex);
                    fis = new FileInputSplit(splitNum++, file.getPath(), position, splitSize, blocks[blockIndex].getHosts());
                    inputSplits.add(fis);
                    position += splitSize;
                }
                if (bytesUnassigned <= 0L) continue;
                blockIndex = this.getBlockIndexForPosition((BlockLocation[])blocks, position, halfSplit, blockIndex);
                fis = new FileInputSplit(splitNum++, file.getPath(), position, bytesUnassigned, blocks[blockIndex].getHosts());
                inputSplits.add(fis);
                continue;
            }
            blocks = fs.getFileBlockLocations(file, 0L, 0L);
            String[] hosts = blocks.length > 0 ? blocks[0].getHosts() : new String[]{};
            FileInputSplit fis = new FileInputSplit(splitNum++, file.getPath(), 0L, 0L, hosts);
            inputSplits.add(fis);
        }
        return inputSplits.toArray(new FileInputSplit[inputSplits.size()]);
    }

    private long addFilesInDir(Path path, List<FileStatus> files, boolean logExcludedFiles) throws IOException {
        FileSystem fs = path.getFileSystem();
        long length = 0L;
        for (FileStatus dir : fs.listStatus(path)) {
            if (dir.isDir()) {
                if (this.acceptFile(dir) && this.enumerateNestedFiles) {
                    length += this.addFilesInDir(dir.getPath(), files, logExcludedFiles);
                    continue;
                }
                if (!logExcludedFiles || !LOG.isDebugEnabled()) continue;
                LOG.debug("Directory " + dir.getPath().toString() + " did not pass the file-filter and is excluded.");
                continue;
            }
            if (this.acceptFile(dir)) {
                files.add(dir);
                length += dir.getLen();
                this.testForUnsplittable(dir);
                continue;
            }
            if (!logExcludedFiles || !LOG.isDebugEnabled()) continue;
            LOG.debug("Directory " + dir.getPath().toString() + " did not pass the file-filter and is excluded.");
        }
        return length;
    }

    protected boolean testForUnsplittable(FileStatus pathFile) {
        if (this.getInflaterInputStreamFactory(pathFile.getPath()) != null) {
            this.unsplittable = true;
            return true;
        }
        return false;
    }

    private InflaterInputStreamFactory<?> getInflaterInputStreamFactory(Path path) {
        String fileExtension = FileInputFormat.extractFileExtension(path.getName());
        if (fileExtension != null) {
            return FileInputFormat.getInflaterInputStreamFactory(fileExtension);
        }
        return null;
    }

    public boolean acceptFile(FileStatus fileStatus) {
        String name = fileStatus.getPath().getName();
        return !name.startsWith("_") && !name.startsWith(".") && !this.filesFilter.filterPath(fileStatus.getPath());
    }

    private int getBlockIndexForPosition(BlockLocation[] blocks, long offset, long halfSplitSize, int startIndex) {
        for (int i = startIndex; i < blocks.length; ++i) {
            long blockStart = blocks[i].getOffset();
            long blockEnd = blockStart + blocks[i].getLength();
            if (offset < blockStart || offset >= blockEnd) continue;
            if (i < blocks.length - 1 && blockEnd - offset < halfSplitSize) {
                return i + 1;
            }
            return i;
        }
        throw new IllegalArgumentException("The given offset is not contained in the any block.");
    }

    @Override
    public void open(FileInputSplit fileSplit) throws IOException {
        this.currentSplit = fileSplit;
        this.splitStart = fileSplit.getStart();
        this.splitLength = fileSplit.getLength();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening input split " + fileSplit.getPath() + " [" + this.splitStart + "," + this.splitLength + "]");
        }
        InputSplitOpenThread isot = new InputSplitOpenThread(fileSplit, this.openTimeout);
        isot.start();
        try {
            this.stream = isot.waitForCompletion();
            this.stream = this.decorateInputStream(this.stream, fileSplit);
        }
        catch (Throwable t) {
            throw new IOException("Error opening the Input Split " + fileSplit.getPath() + " [" + this.splitStart + "," + this.splitLength + "]: " + t.getMessage(), t);
        }
        if (this.splitStart != 0L) {
            this.stream.seek(this.splitStart);
        }
    }

    protected FSDataInputStream decorateInputStream(FSDataInputStream inputStream, FileInputSplit fileSplit) throws Throwable {
        InflaterInputStreamFactory<?> inflaterInputStreamFactory = this.getInflaterInputStreamFactory(fileSplit.getPath());
        if (inflaterInputStreamFactory != null) {
            return new InputStreamFSInputWrapper((InputStream)inflaterInputStreamFactory.create(this.stream));
        }
        return inputStream;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    @Deprecated
    public boolean supportsMultiPaths() {
        return false;
    }

    public String toString() {
        return this.getFilePaths() == null || this.getFilePaths().length == 0 ? "File Input (unknown file)" : "File Input (" + Arrays.toString(this.getFilePaths()) + ')';
    }

    static {
        INFLATER_INPUT_STREAM_FACTORIES = new HashMap();
        FileInputFormat.initDefaultsFromConfiguration(GlobalConfiguration.loadConfiguration());
        FileInputFormat.initDefaultInflaterInputStreamFactories();
    }

    public static class InputSplitOpenThread
    extends Thread {
        private final FileInputSplit split;
        private final long timeout;
        private volatile FSDataInputStream fdis;
        private volatile Throwable error;
        private volatile boolean aborted;

        public InputSplitOpenThread(FileInputSplit split, long timeout) {
            super("Transient InputSplit Opener");
            this.setDaemon(true);
            this.split = split;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                FileSystem fs = FileSystem.get(this.split.getPath().toUri());
                this.fdis = fs.open(this.split.getPath());
                if (this.aborted) {
                    FSDataInputStream f = this.fdis;
                    this.fdis = null;
                    f.close();
                }
            }
            catch (Throwable t) {
                this.error = t;
            }
        }

        public FSDataInputStream waitForCompletion() throws Throwable {
            long start = System.currentTimeMillis();
            long remaining = this.timeout;
            do {
                try {
                    this.join(remaining);
                }
                catch (InterruptedException iex) {
                    this.abortWait();
                    throw iex;
                }
            } while (this.error == null && this.fdis == null && (remaining = this.timeout + start - System.currentTimeMillis()) > 0L);
            if (this.error != null) {
                throw this.error;
            }
            if (this.fdis != null) {
                return this.fdis;
            }
            this.abortWait();
            boolean stillAlive = this.isAlive();
            StringBuilder bld = new StringBuilder(256);
            for (StackTraceElement e : this.getStackTrace()) {
                bld.append("\tat ").append(e.toString()).append('\n');
            }
            throw new IOException("Input opening request timed out. Opener was " + (stillAlive ? "" : "NOT ") + " alive. Stack of split open thread:\n" + bld.toString());
        }

        private void abortWait() {
            this.aborted = true;
            FSDataInputStream inStream = this.fdis;
            this.fdis = null;
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static class FileBaseStatistics
    implements BaseStatistics {
        protected final long fileModTime;
        protected final long fileSize;
        protected final float avgBytesPerRecord;

        public FileBaseStatistics(long fileModTime, long fileSize, float avgBytesPerRecord) {
            this.fileModTime = fileModTime;
            this.fileSize = fileSize;
            this.avgBytesPerRecord = avgBytesPerRecord;
        }

        public long getLastModificationTime() {
            return this.fileModTime;
        }

        @Override
        public long getTotalInputSize() {
            return this.fileSize;
        }

        @Override
        public long getNumberOfRecords() {
            return this.fileSize == -1L || this.avgBytesPerRecord == -1.0f ? -1L : (long)Math.ceil((float)this.fileSize / this.avgBytesPerRecord);
        }

        @Override
        public float getAverageRecordWidth() {
            return this.avgBytesPerRecord;
        }

        public String toString() {
            return "size=" + this.fileSize + ", recWidth=" + this.avgBytesPerRecord + ", modAt=" + this.fileModTime;
        }
    }
}

