/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class DoubleMinimum
implements SimpleAccumulator<Double> {
    private static final long serialVersionUID = 1L;
    private double min = Double.POSITIVE_INFINITY;

    public DoubleMinimum() {
    }

    public DoubleMinimum(double value) {
        this.min = value;
    }

    @Override
    public void add(Double value) {
        this.min = Math.min(this.min, value);
    }

    @Override
    public Double getLocalValue() {
        return this.min;
    }

    @Override
    public void merge(Accumulator<Double, Double> other) {
        this.min = Math.min(this.min, other.getLocalValue());
    }

    @Override
    public void resetLocal() {
        this.min = Double.POSITIVE_INFINITY;
    }

    public DoubleMinimum clone() {
        DoubleMinimum clone = new DoubleMinimum();
        clone.min = this.min;
        return clone;
    }

    @Override
    public void add(double value) {
        this.min = Math.min(this.min, value);
    }

    public double getLocalValuePrimitive() {
        return this.min;
    }

    public String toString() {
        return "DoubleMinimum " + this.min;
    }
}

