/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.predicate;

import java.util.List;
import java.util.Optional;
import org.apache.flink.table.store.file.predicate.FieldRef;
import org.apache.flink.table.store.file.predicate.FunctionVisitor;
import org.apache.flink.table.store.file.predicate.IsNull;
import org.apache.flink.table.store.file.predicate.LeafFunction;
import org.apache.flink.table.store.file.predicate.LeafUnaryFunction;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.types.logical.LogicalType;

public class IsNotNull
extends LeafUnaryFunction {
    public static final IsNotNull INSTANCE = new IsNotNull();

    private IsNotNull() {
    }

    @Override
    public boolean test(LogicalType type, Object field) {
        return field != null;
    }

    @Override
    public boolean test(LogicalType type, long rowCount, FieldStats fieldStats) {
        return fieldStats.nullCount() < rowCount;
    }

    @Override
    public Optional<LeafFunction> negate() {
        return Optional.of(IsNull.INSTANCE);
    }

    @Override
    public <T> T visit(FunctionVisitor<T> visitor, FieldRef fieldRef, List<Object> literals) {
        return visitor.visitIsNotNull(fieldRef);
    }
}

