/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.append;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.compact.CompactManager;
import org.apache.flink.table.store.file.io.CompactIncrement;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.DataFilePathFactory;
import org.apache.flink.table.store.file.io.NewFilesIncrement;
import org.apache.flink.table.store.file.io.RowDataRollingFileWriter;
import org.apache.flink.table.store.file.utils.RecordWriter;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class AppendOnlyWriter
implements RecordWriter<RowData> {
    private final long schemaId;
    private final FileFormat fileFormat;
    private final long targetFileSize;
    private final RowType writeSchema;
    private final DataFilePathFactory pathFactory;
    private final CompactManager compactManager;
    private final boolean forceCompact;
    private final List<DataFileMeta> newFiles;
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;
    private final LongCounter seqNumCounter;
    private RowDataRollingFileWriter writer;

    public AppendOnlyWriter(long schemaId, FileFormat fileFormat, long targetFileSize, RowType writeSchema, long maxSequenceNumber, CompactManager compactManager, boolean forceCompact, DataFilePathFactory pathFactory) {
        this.schemaId = schemaId;
        this.fileFormat = fileFormat;
        this.targetFileSize = targetFileSize;
        this.writeSchema = writeSchema;
        this.pathFactory = pathFactory;
        this.compactManager = compactManager;
        this.forceCompact = forceCompact;
        this.newFiles = new ArrayList<DataFileMeta>();
        this.compactBefore = new ArrayList<DataFileMeta>();
        this.compactAfter = new ArrayList<DataFileMeta>();
        this.seqNumCounter = new LongCounter(maxSequenceNumber + 1L);
        this.writer = this.createRollingRowWriter();
    }

    @Override
    public void write(RowData rowData) throws Exception {
        Preconditions.checkArgument(rowData.getRowKind() == RowKind.INSERT, "Append-only writer can only accept insert row kind, but current row kind is: %s", new Object[]{rowData.getRowKind()});
        this.writer.write(rowData);
    }

    @Override
    public void compact(boolean fullCompaction) throws Exception {
        this.flushWriter(true, fullCompaction);
    }

    @Override
    public void addNewFiles(List<DataFileMeta> files) {
        files.forEach(this.compactManager::addNewFile);
    }

    @Override
    public RecordWriter.CommitIncrement prepareCommit(boolean blocking) throws Exception {
        this.flushWriter(false, false);
        this.trySyncLatestCompaction(blocking || this.forceCompact);
        return this.drainIncrement();
    }

    private void flushWriter(boolean waitForLatestCompaction, boolean forcedFullCompaction) throws Exception {
        ArrayList<DataFileMeta> flushedFiles = new ArrayList<DataFileMeta>();
        if (this.writer != null) {
            this.writer.close();
            flushedFiles.addAll((Collection<DataFileMeta>)this.writer.result());
            this.seqNumCounter.resetLocal();
            this.seqNumCounter.add(DataFileMeta.getMaxSequenceNumber(flushedFiles) + 1L);
            this.writer = this.createRollingRowWriter();
        }
        flushedFiles.forEach(this.compactManager::addNewFile);
        this.trySyncLatestCompaction(waitForLatestCompaction);
        this.compactManager.triggerCompaction(forcedFullCompaction);
        this.newFiles.addAll(flushedFiles);
    }

    @Override
    public void sync() throws Exception {
        this.trySyncLatestCompaction(true);
    }

    @Override
    public void close() throws Exception {
        this.compactManager.cancelCompaction();
        this.sync();
        if (this.writer != null) {
            this.writer.abort();
            this.writer = null;
        }
    }

    private RowDataRollingFileWriter createRollingRowWriter() {
        return new RowDataRollingFileWriter(this.schemaId, this.fileFormat, this.targetFileSize, this.writeSchema, this.pathFactory, this.seqNumCounter);
    }

    private void trySyncLatestCompaction(boolean blocking) throws ExecutionException, InterruptedException {
        this.compactManager.getCompactionResult(blocking).ifPresent(result -> {
            this.compactBefore.addAll(result.before());
            this.compactAfter.addAll(result.after());
        });
    }

    private RecordWriter.CommitIncrement drainIncrement() {
        final NewFilesIncrement newFilesIncrement = new NewFilesIncrement(new ArrayList<DataFileMeta>(this.newFiles), Collections.emptyList());
        final CompactIncrement compactIncrement = new CompactIncrement(new ArrayList<DataFileMeta>(this.compactBefore), new ArrayList<DataFileMeta>(this.compactAfter), Collections.emptyList());
        this.newFiles.clear();
        this.compactBefore.clear();
        this.compactAfter.clear();
        return new RecordWriter.CommitIncrement(){

            @Override
            public NewFilesIncrement newFilesIncrement() {
                return newFilesIncrement;
            }

            @Override
            public CompactIncrement compactIncrement() {
                return compactIncrement;
            }
        };
    }
}

