/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.SafetyNetCloseableRegistry;
import org.apache.flink.core.fs.SafetyNetWrapperFileSystem;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class FileSystemSafetyNet {
    private static final ThreadLocal<SafetyNetCloseableRegistry> REGISTRIES = new ThreadLocal();

    @Internal
    public static void initializeSafetyNetForThread() {
        SafetyNetCloseableRegistry oldRegistry = REGISTRIES.get();
        Preconditions.checkState(null == oldRegistry, "Found an existing FileSystem safety net for this thread: %s This may indicate an accidental repeated initialization, or a leak of the(Inheritable)ThreadLocal through a ThreadPool.", oldRegistry);
        SafetyNetCloseableRegistry newRegistry = new SafetyNetCloseableRegistry();
        REGISTRIES.set(newRegistry);
    }

    @Internal
    public static void closeSafetyNetAndGuardedResourcesForThread() {
        SafetyNetCloseableRegistry registry = REGISTRIES.get();
        if (null != registry) {
            REGISTRIES.remove();
            IOUtils.closeQuietly(registry);
        }
    }

    static FileSystem wrapWithSafetyNetWhenActivated(FileSystem fs) {
        SafetyNetCloseableRegistry reg = REGISTRIES.get();
        return reg != null ? new SafetyNetWrapperFileSystem(fs, reg) : fs;
    }
}

