/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.sql.Time;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;

@PublicEvolving
public final class TimeType
extends LogicalType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_PRECISION = 0;
    public static final int MAX_PRECISION = 9;
    public static final int DEFAULT_PRECISION = 0;
    private static final String FORMAT = "TIME(%d)";
    private static final Set<String> NULL_OUTPUT_CONVERSION = TimeType.conversionSet(Time.class.getName(), LocalTime.class.getName(), Integer.class.getName(), Long.class.getName());
    private static final Set<String> NOT_NULL_INPUT_OUTPUT_CONVERSION = TimeType.conversionSet(Time.class.getName(), LocalTime.class.getName(), Integer.class.getName(), Integer.TYPE.getName(), Long.class.getName(), Long.TYPE.getName());
    private static final Class<?> DEFAULT_CONVERSION = LocalTime.class;
    private final int precision;

    public TimeType(boolean isNullable, int precision) {
        super(isNullable, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE);
        if (precision < 0 || precision > 9) {
            throw new ValidationException(String.format("Time precision must be between %d and %d (both inclusive).", 0, 9));
        }
        this.precision = precision;
    }

    public TimeType(int precision) {
        this(true, precision);
    }

    public TimeType() {
        this(0);
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new TimeType(isNullable, this.precision);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.precision);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        if (this.isNullable()) {
            return NULL_OUTPUT_CONVERSION.contains(clazz.getName());
        }
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeType timeType = (TimeType)o;
        return this.precision == timeType.precision;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision);
    }
}

