/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.manifest.FileKind;
import org.apache.flink.table.store.file.operation.FileStoreScan;
import org.apache.flink.table.store.file.operation.ScanKind;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.SplitGenerator;

public abstract class AbstractDataTableScan
implements DataTableScan {
    private final FileStoreScan scan;
    private final TableSchema tableSchema;
    private final FileStorePathFactory pathFactory;
    private final CoreOptions options;
    private ScanKind scanKind = ScanKind.ALL;

    protected AbstractDataTableScan(FileStoreScan scan, TableSchema tableSchema, FileStorePathFactory pathFactory, CoreOptions options) {
        this.scan = scan;
        this.tableSchema = tableSchema;
        this.pathFactory = pathFactory;
        this.options = options;
    }

    @Override
    public AbstractDataTableScan withSnapshot(long snapshotId) {
        this.scan.withSnapshot(snapshotId);
        return this;
    }

    @Override
    public AbstractDataTableScan withFilter(Predicate predicate) {
        List<String> partitionKeys = this.tableSchema.partitionKeys();
        int[] fieldIdxToPartitionIdx = this.tableSchema.fields().stream().mapToInt(f -> partitionKeys.indexOf(f.name())).toArray();
        ArrayList<Predicate> partitionFilters = new ArrayList<Predicate>();
        ArrayList<Predicate> nonPartitionFilters = new ArrayList<Predicate>();
        for (Predicate p : PredicateBuilder.splitAnd(predicate)) {
            Optional<Predicate> mapped = PredicateBuilder.transformFieldMapping(p, fieldIdxToPartitionIdx);
            if (mapped.isPresent()) {
                partitionFilters.add(mapped.get());
                continue;
            }
            nonPartitionFilters.add(p);
        }
        if (partitionFilters.size() > 0) {
            this.scan.withPartitionFilter(PredicateBuilder.and(partitionFilters));
        }
        if (nonPartitionFilters.size() > 0) {
            this.withNonPartitionFilter(PredicateBuilder.and(nonPartitionFilters));
        }
        return this;
    }

    @Override
    public AbstractDataTableScan withKind(ScanKind scanKind) {
        this.scanKind = scanKind;
        this.scan.withKind(scanKind);
        return this;
    }

    @Override
    public AbstractDataTableScan withLevel(int level) {
        this.scan.withLevel(level);
        return this;
    }

    @VisibleForTesting
    public AbstractDataTableScan withBucket(int bucket) {
        this.scan.withBucket(bucket);
        return this;
    }

    @Override
    public DataTableScan.DataFilePlan plan() {
        FileStoreScan.Plan plan = this.scan.plan();
        Long snapshotId = plan.snapshotId();
        List<DataSplit> splits = AbstractDataTableScan.generateSplits(snapshotId == null ? 0L : snapshotId, this.scanKind != ScanKind.ALL, this.splitGenerator(this.pathFactory), plan.groupByPartFiles(plan.files(FileKind.ADD)));
        return new DataTableScan.DataFilePlan(snapshotId, splits);
    }

    @VisibleForTesting
    public static List<DataSplit> generateSplits(long snapshotId, boolean isIncremental, SplitGenerator splitGenerator, Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> groupedDataFiles) {
        ArrayList<DataSplit> splits = new ArrayList<DataSplit>();
        for (Map.Entry<BinaryRowData, Map<Integer, List<DataFileMeta>>> entry : groupedDataFiles.entrySet()) {
            BinaryRowData partition = entry.getKey();
            Map<Integer, List<DataFileMeta>> buckets = entry.getValue();
            for (Map.Entry<Integer, List<DataFileMeta>> bucketEntry : buckets.entrySet()) {
                int bucket = bucketEntry.getKey();
                if (isIncremental) {
                    splits.add(new DataSplit(snapshotId, partition, bucket, bucketEntry.getValue(), true));
                    continue;
                }
                splitGenerator.split(bucketEntry.getValue()).stream().map(files -> new DataSplit(snapshotId, partition, bucket, (List<DataFileMeta>)files, false)).forEach(splits::add);
            }
        }
        return splits;
    }

    protected abstract SplitGenerator splitGenerator(FileStorePathFactory var1);

    protected abstract void withNonPartitionFilter(Predicate var1);

    public CoreOptions options() {
        return this.options;
    }

    public SnapshotManager snapshotManager() {
        return new SnapshotManager(this.pathFactory.root());
    }
}

