/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

public class SequenceGenerator {
    private final int index;
    private final Generator generator;

    public SequenceGenerator(String field, RowType rowType) {
        this.index = rowType.getFieldNames().indexOf(field);
        if (this.index == -1) {
            throw new RuntimeException(String.format("Can not find sequence field %s in table schema: %s", field, rowType));
        }
        this.generator = rowType.getTypeAt(this.index).accept(new SequenceGeneratorVisitor());
    }

    public long generate(RowData row) {
        return this.generator.generate(row, this.index);
    }

    private static class SequenceGeneratorVisitor
    extends LogicalTypeDefaultVisitor<Generator> {
        private SequenceGeneratorVisitor() {
        }

        @Override
        public Generator visit(CharType charType) {
            return this.stringGenerator();
        }

        @Override
        public Generator visit(VarCharType varCharType) {
            return this.stringGenerator();
        }

        private Generator stringGenerator() {
            return (row, i) -> Long.parseLong(row.getString(i).toString());
        }

        @Override
        public Generator visit(DecimalType decimalType) {
            return (row, i) -> RowDataUtils.castToIntegral(row.getDecimal(i, decimalType.getPrecision(), decimalType.getScale()));
        }

        @Override
        public Generator visit(TinyIntType tinyIntType) {
            return RowData::getByte;
        }

        @Override
        public Generator visit(SmallIntType smallIntType) {
            return RowData::getShort;
        }

        @Override
        public Generator visit(IntType intType) {
            return RowData::getInt;
        }

        @Override
        public Generator visit(BigIntType bigIntType) {
            return RowData::getLong;
        }

        @Override
        public Generator visit(FloatType floatType) {
            return (row, i) -> (long)row.getFloat(i);
        }

        @Override
        public Generator visit(DoubleType doubleType) {
            return (row, i) -> (long)row.getDouble(i);
        }

        @Override
        public Generator visit(DateType dateType) {
            return RowData::getInt;
        }

        @Override
        public Generator visit(TimestampType timestampType) {
            return (row, i) -> row.getTimestamp(i, timestampType.getPrecision()).getMillisecond();
        }

        @Override
        public Generator visit(LocalZonedTimestampType localZonedTimestampType) {
            return (row, i) -> row.getTimestamp(i, localZonedTimestampType.getPrecision()).getMillisecond();
        }

        @Override
        protected Generator defaultMethod(LogicalType logicalType) {
            throw new UnsupportedOperationException("Unsupported type: " + logicalType);
        }
    }

    private static interface Generator {
        public long generate(RowData var1, int var2);
    }
}

