/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive;

import org.apache.flink.table.store.mapred.TableStoreInputFormat;
import org.apache.flink.table.store.mapred.TableStoreOutputFormat;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;

public class TableStoreHiveMetaHook
implements HiveMetaHook {
    public void preCreateTable(Table table) throws MetaException {
        Preconditions.checkArgument(!table.isSetPartitionKeys() || table.getPartitionKeys().isEmpty(), "Flink Table Store currently does not support creating partitioned table with PARTITIONED BY clause. If you want to query from a partitioned table, please add partition columns into the ordinary table columns.");
        table.getSd().setInputFormat(TableStoreInputFormat.class.getCanonicalName());
        table.getSd().setOutputFormat(TableStoreOutputFormat.class.getCanonicalName());
    }

    public void rollbackCreateTable(Table table) throws MetaException {
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean b) throws MetaException {
    }
}

