/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.parquet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.parquet.ParquetReadOptions;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ParquetUtil {
    public static Map<String, Statistics> extractColumnStats(Path path) throws IOException {
        ParquetMetadata parquetMetadata = ParquetUtil.getParquetReader(path).getFooter();
        List<BlockMetaData> blockMetaDataList = parquetMetadata.getBlocks();
        HashMap<String, Statistics> resultStats = new HashMap<String, Statistics>();
        for (BlockMetaData blockMetaData : blockMetaDataList) {
            List<ColumnChunkMetaData> columnChunkMetaDataList = blockMetaData.getColumns();
            for (ColumnChunkMetaData columnChunkMetaData : columnChunkMetaDataList) {
                Statistics midStats;
                Statistics stats = columnChunkMetaData.getStatistics();
                String columnName = columnChunkMetaData.getPath().toDotString();
                if (!resultStats.containsKey(columnName)) {
                    midStats = stats;
                } else {
                    midStats = (Statistics)resultStats.get(columnName);
                    midStats.mergeStatistics(stats);
                }
                resultStats.put(columnName, midStats);
            }
        }
        return resultStats;
    }

    public static ParquetFileReader getParquetReader(Path path) throws IOException {
        HadoopInputFile hadoopInputFile = HadoopInputFile.fromPath(path, new Configuration());
        return ParquetFileReader.open(hadoopInputFile, ParquetReadOptions.builder().build());
    }

    static void assertStatsClass(RowType.RowField field, Statistics stats, Class<? extends Statistics> expectedClass) {
        if (!expectedClass.isInstance(stats)) {
            throw new IllegalArgumentException("Expecting " + expectedClass.getName() + " for field " + field.asSummaryString() + " but found " + stats.getClass().getName());
        }
    }
}

