/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.store.file.catalog.AbstractCatalog;
import org.apache.flink.table.store.file.catalog.Catalog;
import org.apache.flink.table.store.file.catalog.CatalogLock;
import org.apache.flink.table.store.file.schema.SchemaChange;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.schema.UpdateSchema;
import org.apache.flink.table.store.file.utils.FileUtils;

public class FileSystemCatalog
extends AbstractCatalog {
    private final FileSystem fs;
    private final Path warehouse;

    public FileSystemCatalog(Path warehouse) {
        this.warehouse = warehouse;
        this.fs = FileSystemCatalog.uncheck(warehouse::getFileSystem);
    }

    @Override
    public Optional<CatalogLock.Factory> lockFactory() {
        return Optional.empty();
    }

    @Override
    public List<String> listDatabases() {
        ArrayList<String> databases = new ArrayList<String>();
        for (FileStatus status : FileSystemCatalog.uncheck(() -> FileUtils.safelyListFileStatus(this.warehouse))) {
            Path path = status.getPath();
            if (!status.isDir() || !FileSystemCatalog.isDatabase(path)) continue;
            databases.add(FileSystemCatalog.database(path));
        }
        return databases;
    }

    @Override
    public boolean databaseExists(String databaseName) {
        return FileSystemCatalog.uncheck(() -> this.fs.exists(this.databasePath(databaseName)));
    }

    @Override
    public void createDatabase(String name, boolean ignoreIfExists) throws Catalog.DatabaseAlreadyExistException {
        if (this.databaseExists(name)) {
            if (ignoreIfExists) {
                return;
            }
            throw new Catalog.DatabaseAlreadyExistException(name);
        }
        FileSystemCatalog.uncheck(() -> this.fs.mkdirs(this.databasePath(name)));
    }

    @Override
    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        if (!this.databaseExists(name)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.DatabaseNotExistException(name);
        }
        if (!cascade && this.listTables(name).size() > 0) {
            throw new Catalog.DatabaseNotEmptyException(name);
        }
        FileSystemCatalog.uncheck(() -> this.fs.delete(this.databasePath(name), true));
    }

    @Override
    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new Catalog.DatabaseNotExistException(databaseName);
        }
        ArrayList<String> tables = new ArrayList<String>();
        for (FileStatus status : FileSystemCatalog.uncheck(() -> FileUtils.safelyListFileStatus(this.databasePath(databaseName)))) {
            if (!status.isDir() || !this.tableExists(status.getPath())) continue;
            tables.add(status.getPath().getName());
        }
        return tables;
    }

    @Override
    public TableSchema getTableSchema(ObjectPath tablePath) throws Catalog.TableNotExistException {
        Path path = this.getTableLocation(tablePath);
        return new SchemaManager(path).latest().orElseThrow(() -> new Catalog.TableNotExistException(tablePath));
    }

    @Override
    public boolean tableExists(ObjectPath tablePath) {
        return this.tableExists(this.getTableLocation(tablePath));
    }

    private boolean tableExists(Path tablePath) {
        return new SchemaManager(tablePath).listAllIds().size() > 0;
    }

    @Override
    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        Path path = this.getTableLocation(tablePath);
        if (!this.tableExists(path)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new Catalog.TableNotExistException(tablePath);
        }
        FileSystemCatalog.uncheck(() -> this.fs.delete(path, true));
    }

    @Override
    public void createTable(ObjectPath tablePath, UpdateSchema table, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new Catalog.DatabaseNotExistException(tablePath.getDatabaseName());
        }
        Path path = this.getTableLocation(tablePath);
        if (this.tableExists(path)) {
            if (ignoreIfExists) {
                return;
            }
            throw new Catalog.TableAlreadyExistException(tablePath);
        }
        FileSystemCatalog.uncheck(() -> new SchemaManager(path).commitNewVersion(table));
    }

    @Override
    public void alterTable(ObjectPath tablePath, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new Catalog.TableNotExistException(tablePath);
        }
        FileSystemCatalog.uncheck(() -> new SchemaManager(this.getTableLocation(tablePath)).commitChanges(changes));
    }

    private static <T> T uncheck(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isDatabase(Path path) {
        return path.getName().endsWith(".db");
    }

    private static String database(Path path) {
        String name = path.getName();
        return name.substring(0, name.length() - ".db".length());
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    protected String warehouse() {
        return this.warehouse.toString();
    }
}

