/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.table.store.file.utils.JsonSerdeUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;

public class TableStoreJobConf {
    private static final String INTERNAL_LOCATION = "table-store.internal.location";
    private static final String INTERNAL_CATALOG_CONFIG = "table-store.catalog.config";
    private static final String TABLE_STORE_PREFIX = "tablestore.";
    private final JobConf jobConf;

    public TableStoreJobConf(JobConf jobConf) {
        this.jobConf = jobConf;
    }

    public static void configureInputJobProperties(Configuration configuration, Properties properties, Map<String, String> map) {
        map.put(INTERNAL_CATALOG_CONFIG, JsonSerdeUtil.toJson(TableStoreJobConf.extractCatalogConfig(configuration).toMap()));
        map.put(INTERNAL_LOCATION, properties.getProperty("location"));
    }

    public String getLocation() {
        return this.jobConf.get(INTERNAL_LOCATION);
    }

    public org.apache.flink.configuration.Configuration getCatalogConfig() {
        return org.apache.flink.configuration.Configuration.fromMap(JsonSerdeUtil.fromJson(this.jobConf.get(INTERNAL_CATALOG_CONFIG), Map.class));
    }

    public static org.apache.flink.configuration.Configuration extractCatalogConfig(Configuration hiveConf) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (Map.Entry entry : hiveConf) {
            String name = (String)entry.getKey();
            if (!name.startsWith(TABLE_STORE_PREFIX)) continue;
            String value = hiveConf.get(name);
            name = name.substring(TABLE_STORE_PREFIX.length());
            configMap.put(name, value);
        }
        return org.apache.flink.configuration.Configuration.fromMap(configMap);
    }
}

