/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.runtime.operators.join.lookup.ResultRetryStrategy;

public class RetryableLookupFunctionDelegator
extends LookupFunction {
    private final LookupFunction userLookupFunction;
    private final ResultRetryStrategy retryStrategy;
    private final boolean retryEnabled;
    private transient Predicate<Collection<RowData>> retryResultPredicate;

    public RetryableLookupFunctionDelegator(@Nonnull LookupFunction userLookupFunction, @Nonnull ResultRetryStrategy retryStrategy) {
        this.userLookupFunction = userLookupFunction;
        this.retryStrategy = retryStrategy;
        this.retryEnabled = retryStrategy.getRetryPredicate().resultPredicate().isPresent();
    }

    @Override
    public Collection<RowData> lookup(RowData keyRow) throws IOException {
        if (!this.retryEnabled) {
            return this.userLookupFunction.lookup(keyRow);
        }
        int attemptNumber = 1;
        while (true) {
            Collection<RowData> result;
            if (this.retryResultPredicate.test(result = this.userLookupFunction.lookup(keyRow)) && this.retryStrategy.canRetry(attemptNumber)) {
                long backoff = this.retryStrategy.getBackoffTimeMillis(attemptNumber);
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                return result;
            }
            ++attemptNumber;
        }
    }

    @Override
    public void open(FunctionContext context) throws Exception {
        super.open(context);
        this.userLookupFunction.open(context);
        this.retryResultPredicate = this.retryStrategy.getRetryPredicate().resultPredicate().orElse(ignore -> false);
    }

    @Override
    public void close() throws Exception {
        this.userLookupFunction.close();
        super.close();
    }
}

