/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.table.operations.ddl.DropOperation;

public class DropDatabaseOperation
implements DropOperation {
    private final String catalogName;
    private final String databaseName;
    private final boolean ifExists;
    private final boolean cascade;

    public DropDatabaseOperation(String catalogName, String databaseName, boolean ifExists, boolean cascade) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.ifExists = ifExists;
        this.cascade = cascade;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public String asSummaryString() {
        StringBuilder summaryString = new StringBuilder("DROP DATABASE");
        summaryString.append(this.ifExists ? " IF EXISTS " : "");
        summaryString.append(" " + this.catalogName + "." + this.databaseName);
        summaryString.append(this.cascade ? " CASCADE" : " RESTRICT");
        return summaryString.toString();
    }
}

