/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;

class ServiceLoaderUtil {
    ServiceLoaderUtil() {
    }

    static <T> List<LoadResult<T>> load(Class<T> clazz, ClassLoader classLoader) {
        ArrayList<LoadResult<T>> loadResults = new ArrayList<LoadResult<T>>();
        Iterator<T> serviceLoaderIterator = ServiceLoader.load(clazz, classLoader).iterator();
        while (true) {
            try {
                while (true) {
                    T next = serviceLoaderIterator.next();
                    loadResults.add(new LoadResult((Object)next));
                }
            }
            catch (NoSuchElementException e) {
            }
            catch (Throwable t) {
                loadResults.add(new LoadResult(t));
                continue;
            }
            break;
        }
        return loadResults;
    }

    static class LoadResult<T> {
        private final T service;
        private final Throwable error;

        private LoadResult(T service, Throwable error) {
            this.service = service;
            this.error = error;
        }

        private LoadResult(T service) {
            this(service, (Throwable)null);
        }

        private LoadResult(Throwable error) {
            this(null, error);
        }

        public boolean hasFailed() {
            return this.error != null;
        }

        public Throwable getError() {
            return this.error;
        }

        public T getService() {
            return this.service;
        }
    }
}

