/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinarySection;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.binary.LazyBinaryFormat;
import org.apache.flink.table.data.binary.StringUtf8Utils;
import org.apache.flink.util.Preconditions;

@Internal
public final class BinaryStringData
extends LazyBinaryFormat<String>
implements StringData {
    public static final BinaryStringData EMPTY_UTF8 = BinaryStringData.fromBytes(StringUtf8Utils.encodeUTF8(""));

    public BinaryStringData() {
    }

    public BinaryStringData(String javaObject) {
        super(javaObject);
    }

    public BinaryStringData(MemorySegment[] segments, int offset, int sizeInBytes) {
        super(segments, offset, sizeInBytes);
    }

    public BinaryStringData(MemorySegment[] segments, int offset, int sizeInBytes, String javaObject) {
        super(segments, offset, sizeInBytes, javaObject);
    }

    public static BinaryStringData fromAddress(MemorySegment[] segments, int offset, int numBytes) {
        return new BinaryStringData(segments, offset, numBytes);
    }

    public static BinaryStringData fromString(String str) {
        if (str == null) {
            return null;
        }
        return new BinaryStringData(str);
    }

    public static BinaryStringData fromBytes(byte[] bytes) {
        return BinaryStringData.fromBytes(bytes, 0, bytes.length);
    }

    public static BinaryStringData fromBytes(byte[] bytes, int offset, int numBytes) {
        return new BinaryStringData(new MemorySegment[]{MemorySegmentFactory.wrap(bytes)}, offset, numBytes);
    }

    public static BinaryStringData blankString(int length) {
        byte[] spaces = new byte[length];
        Arrays.fill(spaces, (byte)32);
        return BinaryStringData.fromBytes(spaces);
    }

    @Override
    public byte[] toBytes() {
        this.ensureMaterialized();
        return BinarySegmentUtils.getBytes(this.binarySection.segments, this.binarySection.offset, this.binarySection.sizeInBytes);
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryStringData) {
            BinaryStringData other = (BinaryStringData)o;
            if (this.javaObject != null && other.javaObject != null) {
                return ((String)this.javaObject).equals(other.javaObject);
            }
            this.ensureMaterialized();
            other.ensureMaterialized();
            return this.binarySection.equals(other.binarySection);
        }
        return false;
    }

    public int hashCode() {
        this.ensureMaterialized();
        return this.binarySection.hashCode();
    }

    @Override
    public String toString() {
        if (this.javaObject == null) {
            byte[] bytes = BinarySegmentUtils.allocateReuseBytes(this.binarySection.sizeInBytes);
            BinarySegmentUtils.copyToBytes(this.binarySection.segments, this.binarySection.offset, bytes, 0, this.binarySection.sizeInBytes);
            this.javaObject = StringUtf8Utils.decodeUTF8(bytes, 0, this.binarySection.sizeInBytes);
        }
        return (String)this.javaObject;
    }

    @Override
    public int compareTo(@Nonnull StringData o) {
        BinaryStringData other = (BinaryStringData)o;
        if (this.javaObject != null && other.javaObject != null) {
            return ((String)this.javaObject).compareTo((String)other.javaObject);
        }
        this.ensureMaterialized();
        other.ensureMaterialized();
        if (this.binarySection.segments.length == 1 && other.binarySection.segments.length == 1) {
            int len = Math.min(this.binarySection.sizeInBytes, other.binarySection.sizeInBytes);
            MemorySegment seg1 = this.binarySection.segments[0];
            MemorySegment seg2 = other.binarySection.segments[0];
            for (int i = 0; i < len; ++i) {
                int res = (seg1.get(this.binarySection.offset + i) & 0xFF) - (seg2.get(other.binarySection.offset + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            return this.binarySection.sizeInBytes - other.binarySection.sizeInBytes;
        }
        return this.compareMultiSegments(other);
    }

    private int compareMultiSegments(BinaryStringData other) {
        int sizeOfFirst1;
        if (this.binarySection.sizeInBytes == 0 || other.binarySection.sizeInBytes == 0) {
            return this.binarySection.sizeInBytes - other.binarySection.sizeInBytes;
        }
        int len = Math.min(this.binarySection.sizeInBytes, other.binarySection.sizeInBytes);
        MemorySegment seg1 = this.binarySection.segments[0];
        MemorySegment seg2 = other.binarySection.segments[0];
        int segmentSize = this.binarySection.segments[0].size();
        int otherSegmentSize = other.binarySection.segments[0].size();
        int sizeOfFirst2 = otherSegmentSize - other.binarySection.offset;
        int varSegIndex1 = 1;
        int varSegIndex2 = 1;
        for (sizeOfFirst1 = segmentSize - this.binarySection.offset; sizeOfFirst1 <= 0; sizeOfFirst1 += segmentSize) {
            seg1 = this.binarySection.segments[varSegIndex1++];
        }
        while (sizeOfFirst2 <= 0) {
            sizeOfFirst2 += otherSegmentSize;
            seg2 = other.binarySection.segments[varSegIndex2++];
        }
        int offset1 = segmentSize - sizeOfFirst1;
        int offset2 = otherSegmentSize - sizeOfFirst2;
        int needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        while (needCompare > 0) {
            for (int i = 0; i < needCompare; ++i) {
                int res = (seg1.get(offset1 + i) & 0xFF) - (seg2.get(offset2 + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            if (needCompare == len) break;
            len -= needCompare;
            if (sizeOfFirst1 < sizeOfFirst2) {
                seg1 = this.binarySection.segments[varSegIndex1++];
                offset1 = 0;
                offset2 += needCompare;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 -= needCompare;
            } else if (sizeOfFirst1 > sizeOfFirst2) {
                seg2 = other.binarySection.segments[varSegIndex2++];
                offset2 = 0;
                offset1 += needCompare;
                sizeOfFirst2 = otherSegmentSize;
                sizeOfFirst1 -= needCompare;
            } else {
                seg1 = this.binarySection.segments[varSegIndex1++];
                seg2 = other.binarySection.segments[varSegIndex2++];
                offset1 = 0;
                offset2 = 0;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 = otherSegmentSize;
            }
            needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        }
        Preconditions.checkArgument(needCompare == len);
        return this.binarySection.sizeInBytes - other.binarySection.sizeInBytes;
    }

    public int numChars() {
        this.ensureMaterialized();
        if (this.inFirstSegment()) {
            int len = 0;
            for (int i = 0; i < this.binarySection.sizeInBytes; i += BinaryStringData.numBytesForFirstByte(this.getByteOneSegment(i))) {
                ++len;
            }
            return len;
        }
        return this.numCharsMultiSegs();
    }

    private int numCharsMultiSegs() {
        int len = 0;
        int segSize = this.binarySection.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        while (i < this.binarySection.sizeInBytes) {
            int charBytes = BinaryStringData.numBytesForFirstByte(index.value());
            i += charBytes;
            ++len;
            index.skipBytes(charBytes, segSize);
        }
        return len;
    }

    public byte byteAt(int index) {
        this.ensureMaterialized();
        int globalOffset = this.binarySection.offset + index;
        int size = this.binarySection.segments[0].size();
        if (globalOffset < size) {
            return this.binarySection.segments[0].get(globalOffset);
        }
        return this.binarySection.segments[globalOffset / size].get(globalOffset % size);
    }

    @Override
    public MemorySegment[] getSegments() {
        this.ensureMaterialized();
        return super.getSegments();
    }

    @Override
    public int getOffset() {
        this.ensureMaterialized();
        return super.getOffset();
    }

    @Override
    public int getSizeInBytes() {
        this.ensureMaterialized();
        return super.getSizeInBytes();
    }

    public void ensureMaterialized() {
        this.ensureMaterialized(null);
    }

    @Override
    protected BinarySection materialize(TypeSerializer<String> serializer) {
        if (serializer != null) {
            throw new IllegalArgumentException("BinaryStringData does not support custom serializers");
        }
        byte[] bytes = StringUtf8Utils.encodeUTF8((String)this.javaObject);
        return new BinarySection(new MemorySegment[]{MemorySegmentFactory.wrap(bytes)}, 0, bytes.length);
    }

    public BinaryStringData copy() {
        this.ensureMaterialized();
        byte[] copy = BinarySegmentUtils.copyToBytes(this.binarySection.segments, this.binarySection.offset, this.binarySection.sizeInBytes);
        return new BinaryStringData(new MemorySegment[]{MemorySegmentFactory.wrap(copy)}, 0, this.binarySection.sizeInBytes, (String)this.javaObject);
    }

    public BinaryStringData substring(int beginIndex, int endIndex) {
        this.ensureMaterialized();
        if (endIndex <= beginIndex || beginIndex >= this.binarySection.sizeInBytes) {
            return EMPTY_UTF8;
        }
        if (this.inFirstSegment()) {
            int c;
            MemorySegment segment = this.binarySection.segments[0];
            int i = 0;
            for (c = 0; i < this.binarySection.sizeInBytes && c < beginIndex; i += BinaryStringData.numBytesForFirstByte(segment.get(i + this.binarySection.offset)), ++c) {
            }
            int j = i;
            while (i < this.binarySection.sizeInBytes && c < endIndex) {
                i += BinaryStringData.numBytesForFirstByte(segment.get(i + this.binarySection.offset));
                ++c;
            }
            if (i > j) {
                byte[] bytes = new byte[i - j];
                segment.get(this.binarySection.offset + j, bytes, 0, i - j);
                return BinaryStringData.fromBytes(bytes);
            }
            return EMPTY_UTF8;
        }
        return this.substringMultiSegs(beginIndex, endIndex);
    }

    private BinaryStringData substringMultiSegs(int start, int until) {
        int c;
        int charSize;
        int segSize = this.binarySection.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        for (c = 0; i < this.binarySection.sizeInBytes && c < start; i += charSize, ++c) {
            charSize = BinaryStringData.numBytesForFirstByte(index.value());
            index.skipBytes(charSize, segSize);
        }
        int j = i;
        while (i < this.binarySection.sizeInBytes && c < until) {
            int charSize2 = BinaryStringData.numBytesForFirstByte(index.value());
            i += charSize2;
            index.skipBytes(charSize2, segSize);
            ++c;
        }
        if (i > j) {
            return BinaryStringData.fromBytes(BinarySegmentUtils.copyToBytes(this.binarySection.segments, this.binarySection.offset + j, i - j));
        }
        return EMPTY_UTF8;
    }

    public boolean contains(BinaryStringData s) {
        this.ensureMaterialized();
        s.ensureMaterialized();
        if (s.binarySection.sizeInBytes == 0) {
            return true;
        }
        int find = BinarySegmentUtils.find(this.binarySection.segments, this.binarySection.offset, this.binarySection.sizeInBytes, s.binarySection.segments, s.binarySection.offset, s.binarySection.sizeInBytes);
        return find != -1;
    }

    public boolean startsWith(BinaryStringData prefix) {
        this.ensureMaterialized();
        prefix.ensureMaterialized();
        return this.matchAt(prefix, 0);
    }

    public boolean endsWith(BinaryStringData suffix) {
        this.ensureMaterialized();
        suffix.ensureMaterialized();
        return this.matchAt(suffix, this.binarySection.sizeInBytes - suffix.binarySection.sizeInBytes);
    }

    public BinaryStringData trim() {
        this.ensureMaterialized();
        if (this.inFirstSegment()) {
            int s;
            int e = this.binarySection.sizeInBytes - 1;
            for (s = 0; s < this.binarySection.sizeInBytes && this.getByteOneSegment(s) == 32; ++s) {
            }
            while (e >= s && this.getByteOneSegment(e) == 32) {
                --e;
            }
            if (s > e) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(s, e - s + 1);
        }
        return this.trimMultiSegs();
    }

    private BinaryStringData trimMultiSegs() {
        int s;
        int e = this.binarySection.sizeInBytes - 1;
        int segSize = this.binarySection.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (s = 0; s < this.binarySection.sizeInBytes && front.value() == 32; ++s) {
            front.nextByte(segSize);
        }
        SegmentAndOffset behind = this.lastSegmentAndOffset(segSize);
        while (e >= s && behind.value() == 32) {
            --e;
            behind.previousByte(segSize);
        }
        if (s > e) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(s, e);
    }

    public int indexOf(BinaryStringData str, int fromIndex) {
        this.ensureMaterialized();
        str.ensureMaterialized();
        if (str.binarySection.sizeInBytes == 0) {
            return 0;
        }
        if (this.inFirstSegment()) {
            int charIdx;
            int byteIdx = 0;
            for (charIdx = 0; byteIdx < this.binarySection.sizeInBytes && charIdx < fromIndex; byteIdx += BinaryStringData.numBytesForFirstByte(this.getByteOneSegment(byteIdx)), ++charIdx) {
            }
            do {
                if (byteIdx + str.binarySection.sizeInBytes > this.binarySection.sizeInBytes) {
                    return -1;
                }
                if (BinarySegmentUtils.equals(this.binarySection.segments, this.binarySection.offset + byteIdx, str.binarySection.segments, str.binarySection.offset, str.binarySection.sizeInBytes)) {
                    return charIdx;
                }
                byteIdx += BinaryStringData.numBytesForFirstByte(this.getByteOneSegment(byteIdx));
                ++charIdx;
            } while (byteIdx < this.binarySection.sizeInBytes);
            return -1;
        }
        return this.indexOfMultiSegs(str, fromIndex);
    }

    private int indexOfMultiSegs(BinaryStringData str, int fromIndex) {
        int charIdx;
        int charBytes;
        int byteIdx = 0;
        int segSize = this.binarySection.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        for (charIdx = 0; byteIdx < this.binarySection.sizeInBytes && charIdx < fromIndex; byteIdx += charBytes, ++charIdx) {
            charBytes = BinaryStringData.numBytesForFirstByte(index.value());
            index.skipBytes(charBytes, segSize);
        }
        do {
            if (byteIdx + str.binarySection.sizeInBytes > this.binarySection.sizeInBytes) {
                return -1;
            }
            if (BinarySegmentUtils.equals(this.binarySection.segments, this.binarySection.offset + byteIdx, str.binarySection.segments, str.binarySection.offset, str.binarySection.sizeInBytes)) {
                return charIdx;
            }
            charBytes = BinaryStringData.numBytesForFirstByte(index.segment.get(index.offset));
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        } while ((byteIdx += charBytes) < this.binarySection.sizeInBytes);
        return -1;
    }

    public BinaryStringData toUpperCase() {
        if (this.javaObject != null) {
            return this.javaToUpperCase();
        }
        if (this.binarySection.sizeInBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.binarySection.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.binarySection.sizeInBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.binarySection.sizeInBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryStringData.numBytesForFirstByte(b) != 1) {
                return this.javaToUpperCase();
            }
            int upper = Character.toUpperCase(b);
            if (upper > 127) {
                return this.javaToUpperCase();
            }
            bytes[i] = (byte)upper;
            segmentAndOffset.nextByte(size);
        }
        return BinaryStringData.fromBytes(bytes);
    }

    private BinaryStringData javaToUpperCase() {
        return BinaryStringData.fromString(this.toString().toUpperCase());
    }

    public BinaryStringData toLowerCase() {
        if (this.javaObject != null) {
            return this.javaToLowerCase();
        }
        if (this.binarySection.sizeInBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.binarySection.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.binarySection.sizeInBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.binarySection.sizeInBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryStringData.numBytesForFirstByte(b) != 1) {
                return this.javaToLowerCase();
            }
            int lower = Character.toLowerCase(b);
            if (lower > 127) {
                return this.javaToLowerCase();
            }
            bytes[i] = (byte)lower;
            segmentAndOffset.nextByte(size);
        }
        return BinaryStringData.fromBytes(bytes);
    }

    private BinaryStringData javaToLowerCase() {
        return BinaryStringData.fromString(this.toString().toLowerCase());
    }

    byte getByteOneSegment(int i) {
        return this.binarySection.segments[0].get(this.binarySection.offset + i);
    }

    boolean inFirstSegment() {
        return this.binarySection.sizeInBytes + this.binarySection.offset <= this.binarySection.segments[0].size();
    }

    private boolean matchAt(BinaryStringData s, int pos) {
        return this.inFirstSegment() && s.inFirstSegment() ? this.matchAtOneSeg(s, pos) : this.matchAtVarSeg(s, pos);
    }

    private boolean matchAtOneSeg(BinaryStringData s, int pos) {
        return s.binarySection.sizeInBytes + pos <= this.binarySection.sizeInBytes && pos >= 0 && this.binarySection.segments[0].equalTo(s.binarySection.segments[0], this.binarySection.offset + pos, s.binarySection.offset, s.binarySection.sizeInBytes);
    }

    private boolean matchAtVarSeg(BinaryStringData s, int pos) {
        return s.binarySection.sizeInBytes + pos <= this.binarySection.sizeInBytes && pos >= 0 && BinarySegmentUtils.equals(this.binarySection.segments, this.binarySection.offset + pos, s.binarySection.segments, s.binarySection.offset, s.binarySection.sizeInBytes);
    }

    BinaryStringData copyBinaryStringInOneSeg(int start, int len) {
        byte[] newBytes = new byte[len];
        this.binarySection.segments[0].get(this.binarySection.offset + start, newBytes, 0, len);
        return BinaryStringData.fromBytes(newBytes);
    }

    BinaryStringData copyBinaryString(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        BinarySegmentUtils.copyToBytes(this.binarySection.segments, this.binarySection.offset + start, newBytes, 0, len);
        return BinaryStringData.fromBytes(newBytes);
    }

    SegmentAndOffset firstSegmentAndOffset(int segSize) {
        int segIndex = this.binarySection.offset / segSize;
        return new SegmentAndOffset(segIndex, this.binarySection.offset % segSize);
    }

    SegmentAndOffset lastSegmentAndOffset(int segSize) {
        int lastOffset = this.binarySection.offset + this.binarySection.sizeInBytes - 1;
        int segIndex = lastOffset / segSize;
        return new SegmentAndOffset(segIndex, lastOffset % segSize);
    }

    private SegmentAndOffset startSegmentAndOffset(int segSize) {
        return this.inFirstSegment() ? new SegmentAndOffset(0, this.binarySection.offset) : this.firstSegmentAndOffset(segSize);
    }

    static int numBytesForFirstByte(byte b) {
        if (b >= 0) {
            return 1;
        }
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return 2;
        }
        if (b >> 4 == -2) {
            return 3;
        }
        if (b >> 3 == -2) {
            return 4;
        }
        return 1;
    }

    class SegmentAndOffset {
        int segIndex;
        MemorySegment segment;
        int offset;

        private SegmentAndOffset(int segIndex, int offset) {
            this.segIndex = segIndex;
            this.segment = BinaryStringData.this.binarySection.segments[segIndex];
            this.offset = offset;
        }

        private void assignSegment() {
            this.segment = this.segIndex >= 0 && this.segIndex < BinaryStringData.this.binarySection.segments.length ? BinaryStringData.this.binarySection.segments[this.segIndex] : null;
        }

        void previousByte(int segSize) {
            --this.offset;
            if (this.offset == -1) {
                --this.segIndex;
                this.assignSegment();
                this.offset = segSize - 1;
            }
        }

        void nextByte(int segSize) {
            ++this.offset;
            this.checkAdvance(segSize);
        }

        private void checkAdvance(int segSize) {
            if (this.offset == segSize) {
                this.advance();
            }
        }

        private void advance() {
            ++this.segIndex;
            this.assignSegment();
            this.offset = 0;
        }

        void skipBytes(int n, int segSize) {
            int remaining = segSize - this.offset;
            if (remaining > n) {
                this.offset += n;
            } else {
                while (true) {
                    int toSkip;
                    if ((n -= (toSkip = Math.min(remaining, n))) <= 0) {
                        this.offset += toSkip;
                        this.checkAdvance(segSize);
                        return;
                    }
                    this.advance();
                    remaining = segSize - this.offset;
                }
            }
        }

        byte value() {
            return this.segment.get(this.offset);
        }
    }
}

