/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ResolvedCatalogView
implements ResolvedCatalogBaseTable<CatalogView>,
CatalogView {
    private final CatalogView origin;
    private final ResolvedSchema resolvedSchema;

    public ResolvedCatalogView(CatalogView origin, ResolvedSchema resolvedSchema) {
        this.origin = Preconditions.checkNotNull(origin, "Original catalog view must not be null.");
        this.resolvedSchema = Preconditions.checkNotNull(resolvedSchema, "Resolved schema must not be null.");
    }

    @Override
    public CatalogView getOrigin() {
        return this.origin;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.origin.getOptions();
    }

    @Override
    public Schema getUnresolvedSchema() {
        return this.origin.getUnresolvedSchema();
    }

    @Override
    public String getComment() {
        return this.origin.getComment();
    }

    @Override
    public CatalogBaseTable copy() {
        return new ResolvedCatalogView((CatalogView)this.origin.copy(), this.resolvedSchema);
    }

    @Override
    public Optional<String> getDescription() {
        return this.origin.getDescription();
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return this.origin.getDetailedDescription();
    }

    @Override
    public String getOriginalQuery() {
        return this.origin.getOriginalQuery();
    }

    @Override
    public String getExpandedQuery() {
        return this.origin.getExpandedQuery();
    }
}

