/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.co.BatchCoBroadcastWithNonKeyedOperator;
import org.apache.flink.streaming.api.operators.co.CoBroadcastWithNonKeyedOperator;
import org.apache.flink.streaming.api.transformations.BroadcastStateTransformation;
import org.apache.flink.streaming.runtime.translators.AbstractTwoInputTransformationTranslator;
import org.apache.flink.util.Preconditions;

@Internal
public class BroadcastStateTransformationTranslator<IN1, IN2, OUT>
extends AbstractTwoInputTransformationTranslator<IN1, IN2, OUT, BroadcastStateTransformation<IN1, IN2, OUT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(BroadcastStateTransformation<IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(context);
        BatchCoBroadcastWithNonKeyedOperator<IN1, IN2, OUT> operator = new BatchCoBroadcastWithNonKeyedOperator<IN1, IN2, OUT>(transformation.getUserFunction(), transformation.getBroadcastStateDescriptors());
        return this.translateInternal(transformation, transformation.getRegularInput(), transformation.getBroadcastInput(), SimpleOperatorFactory.of(operator), null, null, null, context);
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(BroadcastStateTransformation<IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(context);
        CoBroadcastWithNonKeyedOperator<IN1, IN2, OUT> operator = new CoBroadcastWithNonKeyedOperator<IN1, IN2, OUT>(transformation.getUserFunction(), transformation.getBroadcastStateDescriptors());
        return this.translateInternal(transformation, transformation.getRegularInput(), transformation.getBroadcastInput(), SimpleOperatorFactory.of(operator), null, null, null, context);
    }
}

