/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@PublicEvolving
public class TimestampedValue<T> {
    private T value;
    private long timestamp;
    private boolean hasTimestamp;

    public TimestampedValue(T value) {
        this.value = value;
    }

    public TimestampedValue(T value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
        this.hasTimestamp = true;
    }

    public T getValue() {
        return this.value;
    }

    public long getTimestamp() {
        if (this.hasTimestamp) {
            return this.timestamp;
        }
        throw new IllegalStateException("Record has no timestamp. Is the time characteristic set to 'ProcessingTime', or did you forget to call 'DataStream.assignTimestampsAndWatermarks(...)'?");
    }

    public boolean hasTimestamp() {
        return this.hasTimestamp;
    }

    public StreamRecord<T> getStreamRecord() {
        StreamRecord<T> streamRecord = new StreamRecord<T>(this.value);
        if (this.hasTimestamp) {
            streamRecord.setTimestamp(this.timestamp);
        }
        return streamRecord;
    }

    public static <T> TimestampedValue<T> from(StreamRecord<T> streamRecord) {
        if (streamRecord.hasTimestamp()) {
            return new TimestampedValue<T>(streamRecord.getValue(), streamRecord.getTimestamp());
        }
        return new TimestampedValue<T>(streamRecord.getValue());
    }
}

