/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.streaming.runtime.io.AbstractStreamTaskNetworkInput;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.watermarkstatus.StatusWatermarkValve;

@Internal
public final class StreamTaskNetworkInput<T>
extends AbstractStreamTaskNetworkInput<T, SpillingAdaptiveSpanningRecordDeserializer<DeserializationDelegate<StreamElement>>> {
    public StreamTaskNetworkInput(CheckpointedInputGate checkpointedInputGate, TypeSerializer<T> inputSerializer, IOManager ioManager, StatusWatermarkValve statusWatermarkValve, int inputIndex) {
        super(checkpointedInputGate, inputSerializer, statusWatermarkValve, inputIndex, StreamTaskNetworkInput.getRecordDeserializers(checkpointedInputGate, ioManager));
    }

    private static Map<InputChannelInfo, SpillingAdaptiveSpanningRecordDeserializer<DeserializationDelegate<StreamElement>>> getRecordDeserializers(CheckpointedInputGate checkpointedInputGate, IOManager ioManager) {
        return checkpointedInputGate.getChannelInfos().stream().collect(Collectors.toMap(Function.identity(), unused -> new SpillingAdaptiveSpanningRecordDeserializer(ioManager.getSpillingDirectoriesPaths())));
    }

    @Override
    public CompletableFuture<Void> prepareSnapshot(ChannelStateWriter channelStateWriter, long checkpointId) throws CheckpointException {
        for (Map.Entry e : this.recordDeserializers.entrySet()) {
            try {
                channelStateWriter.addInputData(checkpointId, (InputChannelInfo)e.getKey(), -2, ((SpillingAdaptiveSpanningRecordDeserializer)e.getValue()).getUnconsumedBuffer());
            }
            catch (IOException ioException) {
                throw new CheckpointException(CheckpointFailureReason.IO_EXCEPTION, (Throwable)ioException);
            }
        }
        return this.checkpointedInputGate.getAllBarriersReceivedFuture(checkpointId);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.checkpointedInputGate.close();
    }
}

