/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.flink.api.connector.source.ExternallyInducedSourceReader;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.runtime.io.DataInputStatus;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamTaskSourceInput;

public class StreamTaskExternallyInducedSourceInput<T>
extends StreamTaskSourceInput<T> {
    private final Consumer<Long> checkpointTriggeringHook;
    private final ExternallyInducedSourceReader<T, ?> sourceReader;
    private CompletableFuture<?> blockFuture;

    public StreamTaskExternallyInducedSourceInput(SourceOperator<T, ?> operator, Consumer<Long> checkpointTriggeringHook, int inputGateIndex, int inputIndex) {
        super(operator, inputGateIndex, inputIndex);
        this.checkpointTriggeringHook = checkpointTriggeringHook;
        this.sourceReader = (ExternallyInducedSourceReader)operator.getSourceReader();
    }

    public void blockUntil(CompletableFuture<?> blockFuture) {
        this.blockFuture = blockFuture;
        blockFuture.whenComplete((v, e) -> this.unblock());
    }

    private void unblock() {
        this.blockFuture = null;
    }

    @Override
    public DataInputStatus emitNext(PushingAsyncDataInput.DataOutput<T> output) throws Exception {
        if (this.blockFuture != null) {
            return DataInputStatus.NOTHING_AVAILABLE;
        }
        DataInputStatus status = super.emitNext(output);
        if (status == DataInputStatus.NOTHING_AVAILABLE) {
            this.sourceReader.shouldTriggerCheckpoint().ifPresent(this.checkpointTriggeringHook);
        }
        return status;
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        if (this.blockFuture != null) {
            return this.blockFuture;
        }
        return super.getAvailableFuture();
    }
}

