/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TraversableOnceException;

public class ReusingMutableToRegularIteratorWrapper<T>
implements Iterator<T>,
Iterable<T> {
    private final MutableObjectIterator<T> source;
    private T current;
    private T next;
    private boolean currentIsAvailable;
    private boolean iteratorAvailable = true;

    public ReusingMutableToRegularIteratorWrapper(MutableObjectIterator<T> source, TypeSerializer<T> serializer) {
        this.source = source;
        this.current = serializer.createInstance();
        this.next = serializer.createInstance();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIsAvailable) {
            return true;
        }
        try {
            this.next = this.source.next(this.next);
            if (this.next != null) {
                T tmp = this.current;
                this.current = this.next;
                this.next = tmp;
                this.currentIsAvailable = true;
                return true;
            }
            return false;
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error reading next record: " + ioex.getMessage(), ioex);
        }
    }

    @Override
    public T next() {
        if (this.currentIsAvailable || this.hasNext()) {
            this.currentIsAvailable = false;
            return this.current;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iteratorAvailable) {
            this.iteratorAvailable = false;
            return this;
        }
        throw new TraversableOnceException();
    }
}

