/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collection;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.metrics.AbstractLatencyTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateLatencyMetricBase;

class LatencyTrackingAggregatingState<K, N, IN, ACC, OUT>
extends AbstractLatencyTrackState<K, N, ACC, InternalAggregatingState<K, N, IN, ACC, OUT>, AggregatingStateLatencyMetrics>
implements InternalAggregatingState<K, N, IN, ACC, OUT> {
    LatencyTrackingAggregatingState(String stateName, InternalAggregatingState<K, N, IN, ACC, OUT> original, LatencyTrackingStateConfig latencyTrackingStateConfig) {
        super(original, new AggregatingStateLatencyMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()));
    }

    @Override
    public OUT get() throws Exception {
        if (((AggregatingStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnGet()) {
            return (OUT)this.trackLatencyWithException(() -> ((InternalAggregatingState)this.original).get(), "aggregatingStateGetLatency");
        }
        return ((InternalAggregatingState)this.original).get();
    }

    @Override
    public void add(IN value) throws Exception {
        if (((AggregatingStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnAdd()) {
            this.trackLatencyWithException(() -> ((InternalAggregatingState)this.original).add(value), "aggregatingStateAddLatency");
        } else {
            ((InternalAggregatingState)this.original).add(value);
        }
    }

    @Override
    public ACC getInternal() throws Exception {
        return (ACC)((InternalAggregatingState)this.original).getInternal();
    }

    @Override
    public void updateInternal(ACC valueToStore) throws Exception {
        ((InternalAggregatingState)this.original).updateInternal(valueToStore);
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (((AggregatingStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnMergeNamespace()) {
            this.trackLatencyWithException(() -> ((InternalAggregatingState)this.original).mergeNamespaces(target, sources), "aggregatingStateMergeNamespacesLatency");
        } else {
            ((InternalAggregatingState)this.original).mergeNamespaces(target, sources);
        }
    }

    static class AggregatingStateLatencyMetrics
    extends StateLatencyMetricBase {
        private static final String AGGREGATING_STATE_GET_LATENCY = "aggregatingStateGetLatency";
        private static final String AGGREGATING_STATE_ADD_LATENCY = "aggregatingStateAddLatency";
        private static final String AGGREGATING_STATE_MERGE_NAMESPACES_LATENCY = "aggregatingStateMergeNamespacesLatency";
        private int getCount = 0;
        private int addCount = 0;
        private int mergeNamespaceCount = 0;

        private AggregatingStateLatencyMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getAddCount() {
            return this.addCount;
        }

        int getMergeNamespaceCount() {
            return this.mergeNamespaceCount;
        }

        private boolean trackLatencyOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackLatencyOnAdd() {
            this.addCount = this.loopUpdateCounter(this.addCount);
            return this.addCount == 1;
        }

        private boolean trackLatencyOnMergeNamespace() {
            this.mergeNamespaceCount = this.loopUpdateCounter(this.mergeNamespaceCount);
            return this.mergeNamespaceCount == 1;
        }
    }
}

