/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.io.Serializable;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.util.JvmUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public final class ThreadDumpInfo
implements ResponseBody,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_NAME_THREAD_INFOS = "threadInfos";
    @JsonProperty(value="threadInfos")
    private final Collection<ThreadInfo> threadInfos;

    private ThreadDumpInfo(Collection<ThreadInfo> threadInfos) {
        this.threadInfos = threadInfos;
    }

    public Collection<ThreadInfo> getThreadInfos() {
        return this.threadInfos;
    }

    @JsonCreator
    public static ThreadDumpInfo create(@JsonProperty(value="threadInfos") Collection<ThreadInfo> threadInfos) {
        return new ThreadDumpInfo(threadInfos);
    }

    public static ThreadDumpInfo dumpAndCreate(int stacktraceMaxDepth) {
        return ThreadDumpInfo.create(JvmUtils.createThreadDump().stream().map(threadInfo -> ThreadInfo.create(threadInfo.getThreadName(), ThreadDumpInfo.stringifyThreadInfo(threadInfo, stacktraceMaxDepth))).collect(Collectors.toList()));
    }

    @VisibleForTesting
    protected static String stringifyThreadInfo(java.lang.management.ThreadInfo threadInfo, int maxDepth) {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId() + " " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            sb.append(" on " + threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"" + threadInfo.getLockOwnerName() + "\" Id=" + threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTraceElements = threadInfo.getStackTrace();
        for (i = 0; i < stackTraceElements.length && i < maxDepth; ++i) {
            StackTraceElement ste = stackTraceElements[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : threadInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + lockInfo);
                sb.append('\n');
            }
        }
        if (i < threadInfo.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = threadInfo.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static final class ThreadInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String FIELD_NAME_THREAD_NAME = "threadName";
        public static final String FIELD_NAME_THREAD_INFO = "stringifiedThreadInfo";
        @JsonProperty(value="threadName")
        private final String threadName;
        @JsonProperty(value="stringifiedThreadInfo")
        private final String stringifiedThreadInfo;

        private ThreadInfo(String threadName, String stringifiedThreadInfo) {
            this.threadName = threadName;
            this.stringifiedThreadInfo = stringifiedThreadInfo;
        }

        @JsonCreator
        public static ThreadInfo create(@JsonProperty(value="threadName") String threadName, @JsonProperty(value="stringifiedThreadInfo") String stringifiedThreadInfo) {
            return new ThreadInfo(threadName, stringifiedThreadInfo);
        }

        public String getThreadName() {
            return this.threadName;
        }

        public String getStringifiedThreadInfo() {
            return this.stringifiedThreadInfo;
        }

        public String toString() {
            return this.stringifiedThreadInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreadInfo that = (ThreadInfo)o;
            return Objects.equals(this.threadName, that.threadName) && Objects.equals(this.stringifiedThreadInfo, that.stringifiedThreadInfo);
        }

        public int hashCode() {
            return Objects.hash(this.threadName, this.stringifiedThreadInfo);
        }
    }
}

