/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;
import org.apache.flink.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricQueryService
extends RpcEndpoint
implements MetricQueryServiceGateway {
    private static final Logger LOG = LoggerFactory.getLogger(MetricQueryService.class);
    public static final String METRIC_QUERY_SERVICE_NAME = "MetricQueryService";
    private static final String SIZE_EXCEEDED_LOG_TEMPLATE = "{} will not be reported as the metric dump would exceed the maximum size of {} bytes.";
    private static final CharacterFilter FILTER = new CharacterFilter(){

        public String filterCharacters(String input) {
            return MetricQueryService.replaceInvalidChars(input);
        }
    };
    private final MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
    private final Map<Gauge<?>, Tuple2<QueryScopeInfo, String>> gauges = new HashMap();
    private final Map<Counter, Tuple2<QueryScopeInfo, String>> counters = new HashMap<Counter, Tuple2<QueryScopeInfo, String>>();
    private final Map<Histogram, Tuple2<QueryScopeInfo, String>> histograms = new HashMap<Histogram, Tuple2<QueryScopeInfo, String>>();
    private final Map<Meter, Tuple2<QueryScopeInfo, String>> meters = new HashMap<Meter, Tuple2<QueryScopeInfo, String>>();
    private final long messageSizeLimit;

    public MetricQueryService(RpcService rpcService, String endpointId, long messageSizeLimit) {
        super(rpcService, endpointId);
        this.messageSizeLimit = messageSizeLimit;
    }

    public CompletableFuture<Void> onStop() {
        this.serializer.close();
        return CompletableFuture.completedFuture(null);
    }

    public void addMetric(String metricName, Metric metric, AbstractMetricGroup group) {
        this.runAsync(() -> {
            QueryScopeInfo info = group.getQueryServiceMetricInfo(FILTER);
            if (metric instanceof Counter) {
                this.counters.put((Counter)metric, new Tuple2<QueryScopeInfo, String>(info, FILTER.filterCharacters(metricName)));
            } else if (metric instanceof Gauge) {
                this.gauges.put((Gauge)metric, new Tuple2<QueryScopeInfo, String>(info, FILTER.filterCharacters(metricName)));
            } else if (metric instanceof Histogram) {
                this.histograms.put((Histogram)metric, new Tuple2<QueryScopeInfo, String>(info, FILTER.filterCharacters(metricName)));
            } else if (metric instanceof Meter) {
                this.meters.put((Meter)metric, new Tuple2<QueryScopeInfo, String>(info, FILTER.filterCharacters(metricName)));
            }
        });
    }

    public void removeMetric(Metric metric) {
        this.runAsync(() -> {
            if (metric instanceof Counter) {
                this.counters.remove(metric);
            } else if (metric instanceof Gauge) {
                this.gauges.remove(metric);
            } else if (metric instanceof Histogram) {
                this.histograms.remove(metric);
            } else if (metric instanceof Meter) {
                this.meters.remove(metric);
            }
        });
    }

    @Override
    public CompletableFuture<MetricDumpSerialization.MetricSerializationResult> queryMetrics(Time timeout) {
        return this.callAsync(() -> this.enforceSizeLimit(this.serializer.serialize(this.counters, this.gauges, this.histograms, this.meters)), TimeUtils.toDuration(timeout));
    }

    private MetricDumpSerialization.MetricSerializationResult enforceSizeLimit(MetricDumpSerialization.MetricSerializationResult serializationResult) {
        int currentLength = 0;
        boolean hasExceededBefore = false;
        byte[] serializedCounters = serializationResult.serializedCounters;
        int numCounters = serializationResult.numCounters;
        if (this.exceedsMessageSizeLimit(currentLength + serializationResult.serializedCounters.length)) {
            this.logDumpSizeWouldExceedLimit("Counters", hasExceededBefore);
            hasExceededBefore = true;
            serializedCounters = new byte[]{};
            numCounters = 0;
        } else {
            currentLength += serializedCounters.length;
        }
        byte[] serializedMeters = serializationResult.serializedMeters;
        int numMeters = serializationResult.numMeters;
        if (this.exceedsMessageSizeLimit(currentLength + serializationResult.serializedMeters.length)) {
            this.logDumpSizeWouldExceedLimit("Meters", hasExceededBefore);
            hasExceededBefore = true;
            serializedMeters = new byte[]{};
            numMeters = 0;
        } else {
            currentLength += serializedMeters.length;
        }
        byte[] serializedGauges = serializationResult.serializedGauges;
        int numGauges = serializationResult.numGauges;
        if (this.exceedsMessageSizeLimit(currentLength + serializationResult.serializedGauges.length)) {
            this.logDumpSizeWouldExceedLimit("Gauges", hasExceededBefore);
            hasExceededBefore = true;
            serializedGauges = new byte[]{};
            numGauges = 0;
        } else {
            currentLength += serializedGauges.length;
        }
        byte[] serializedHistograms = serializationResult.serializedHistograms;
        int numHistograms = serializationResult.numHistograms;
        if (this.exceedsMessageSizeLimit(currentLength + serializationResult.serializedHistograms.length)) {
            this.logDumpSizeWouldExceedLimit("Histograms", hasExceededBefore);
            hasExceededBefore = true;
            serializedHistograms = new byte[]{};
            numHistograms = 0;
        }
        return new MetricDumpSerialization.MetricSerializationResult(serializedCounters, serializedGauges, serializedMeters, serializedHistograms, numCounters, numGauges, numMeters, numHistograms);
    }

    private boolean exceedsMessageSizeLimit(int currentSize) {
        return (long)currentSize > this.messageSizeLimit;
    }

    private void logDumpSizeWouldExceedLimit(String metricType, boolean hasExceededBefore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(SIZE_EXCEEDED_LOG_TEMPLATE, (Object)metricType, (Object)this.messageSizeLimit);
        } else if (!hasExceededBefore) {
            LOG.info(SIZE_EXCEEDED_LOG_TEMPLATE, (Object)"Some metrics", (Object)this.messageSizeLimit);
        }
    }

    private static String replaceInvalidChars(String str) {
        char[] chars = null;
        int strLen = str.length();
        int pos = 0;
        block3: for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ' ': 
                case ',': 
                case '.': 
                case ':': {
                    if (chars == null) {
                        chars = str.toCharArray();
                    }
                    chars[pos++] = 95;
                    continue block3;
                }
                default: {
                    if (chars != null) {
                        chars[pos] = c;
                    }
                    ++pos;
                }
            }
        }
        return chars == null ? str : new String(chars, 0, pos);
    }

    public static MetricQueryService createMetricQueryService(RpcService rpcService, ResourceID resourceID, long maximumFrameSize) {
        String endpointId = resourceID == null ? METRIC_QUERY_SERVICE_NAME : "MetricQueryService_" + resourceID.getResourceIdString();
        return new MetricQueryService(rpcService, endpointId, maximumFrameSize);
    }
}

