/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public final class SlotInfoWithUtilization
implements SlotInfo {
    private final SlotInfo slotInfoDelegate;
    private final double taskExecutorUtilization;

    private SlotInfoWithUtilization(SlotInfo slotInfo, double taskExecutorUtilization) {
        this.slotInfoDelegate = slotInfo;
        this.taskExecutorUtilization = taskExecutorUtilization;
    }

    double getTaskExecutorUtilization() {
        return this.taskExecutorUtilization;
    }

    @Override
    public AllocationID getAllocationId() {
        return this.slotInfoDelegate.getAllocationId();
    }

    @Override
    public TaskManagerLocation getTaskManagerLocation() {
        return this.slotInfoDelegate.getTaskManagerLocation();
    }

    @Override
    public int getPhysicalSlotNumber() {
        return this.slotInfoDelegate.getPhysicalSlotNumber();
    }

    @Override
    public ResourceProfile getResourceProfile() {
        return this.slotInfoDelegate.getResourceProfile();
    }

    @Override
    public boolean willBeOccupiedIndefinitely() {
        return this.slotInfoDelegate.willBeOccupiedIndefinitely();
    }

    public static SlotInfoWithUtilization from(SlotInfo slotInfo, double taskExecutorUtilization) {
        return new SlotInfoWithUtilization(slotInfo, taskExecutorUtilization);
    }
}

