/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.UserCodeClassLoader;

@Internal
public class SerializationSchemaAdapter
implements Encoder<RowData> {
    private static final long serialVersionUID = 1L;
    static final byte LINE_DELIMITER = "\n".getBytes(StandardCharsets.UTF_8)[0];
    private final SerializationSchema<RowData> serializationSchema;
    private transient boolean open;

    public SerializationSchemaAdapter(SerializationSchema<RowData> serializationSchema) {
        this.serializationSchema = serializationSchema;
    }

    @Override
    public void encode(RowData element, OutputStream stream) throws IOException {
        this.checkOpened();
        stream.write(this.serializationSchema.serialize(element));
        stream.write(LINE_DELIMITER);
    }

    private void checkOpened() throws IOException {
        if (!this.open) {
            try {
                this.serializationSchema.open(new SerializationSchema.InitializationContext(){

                    @Override
                    public MetricGroup getMetricGroup() {
                        return new UnregisteredMetricsGroup();
                    }

                    @Override
                    public UserCodeClassLoader getUserCodeClassLoader() {
                        return (UserCodeClassLoader)((Object)Thread.currentThread().getContextClassLoader());
                    }
                });
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.open = true;
        }
    }
}

