/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.NestedSerializersSnapshotDelegate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class CompositeTypeSerializerSnapshot<T, S extends TypeSerializer<T>>
implements TypeSerializerSnapshot<T> {
    private static final int MAGIC_NUMBER = 911108;
    private static final int VERSION = 3;
    private static final int HIGHEST_LEGACY_READ_VERSION = 2;
    private NestedSerializersSnapshotDelegate nestedSerializersSnapshotDelegate;
    private final Class<S> correspondingSerializerClass;

    public CompositeTypeSerializerSnapshot(Class<? extends TypeSerializer> correspondingSerializerClass) {
        this.correspondingSerializerClass = Preconditions.checkNotNull(correspondingSerializerClass);
    }

    public CompositeTypeSerializerSnapshot(S serializerInstance) {
        Preconditions.checkNotNull(serializerInstance);
        this.nestedSerializersSnapshotDelegate = new NestedSerializersSnapshotDelegate(this.getNestedSerializers(serializerInstance));
        this.correspondingSerializerClass = serializerInstance.getClass();
    }

    @Override
    public final int getCurrentVersion() {
        return 3;
    }

    @Override
    public final void writeSnapshot(DataOutputView out) throws IOException {
        this.internalWriteOuterSnapshot(out);
        this.nestedSerializersSnapshotDelegate.writeNestedSerializerSnapshots(out);
    }

    @Override
    public final void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        if (readVersion > 2) {
            this.internalReadOuterSnapshot(in, userCodeClassLoader);
        } else {
            this.legacyInternalReadOuterSnapshot(readVersion, in, userCodeClassLoader);
        }
        this.nestedSerializersSnapshotDelegate = NestedSerializersSnapshotDelegate.readNestedSerializerSnapshots(in, userCodeClassLoader);
    }

    public TypeSerializerSnapshot<?>[] getNestedSerializerSnapshots() {
        return this.nestedSerializersSnapshotDelegate.getNestedSerializerSnapshots();
    }

    @Override
    public final TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
        return this.internalResolveSchemaCompatibility(newSerializer, this.nestedSerializersSnapshotDelegate.getNestedSerializerSnapshots());
    }

    @Internal
    TypeSerializerSchemaCompatibility<T> internalResolveSchemaCompatibility(TypeSerializer<T> newSerializer, TypeSerializerSnapshot<?>[] snapshots) {
        if (newSerializer.getClass() != this.correspondingSerializerClass) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        TypeSerializer castedNewSerializer = (TypeSerializer)this.correspondingSerializerClass.cast(newSerializer);
        OuterSchemaCompatibility outerSchemaCompatibility = this.resolveOuterSchemaCompatibility(castedNewSerializer);
        TypeSerializer<?>[] newNestedSerializers = this.getNestedSerializers(castedNewSerializer);
        if (newNestedSerializers.length != snapshots.length) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        return this.constructFinalSchemaCompatibilityResult(newNestedSerializers, snapshots, outerSchemaCompatibility);
    }

    @Internal
    void setNestedSerializersSnapshotDelegate(NestedSerializersSnapshotDelegate delegate) {
        this.nestedSerializersSnapshotDelegate = Preconditions.checkNotNull(delegate);
    }

    @Override
    public final TypeSerializer<T> restoreSerializer() {
        S serializer = this.createOuterSerializerWithNestedSerializers(this.nestedSerializersSnapshotDelegate.getRestoredNestedSerializers());
        return serializer;
    }

    protected abstract int getCurrentOuterSnapshotVersion();

    protected abstract TypeSerializer<?>[] getNestedSerializers(S var1);

    protected abstract S createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] var1);

    protected void writeOuterSnapshot(DataOutputView out) throws IOException {
    }

    protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
    }

    @Deprecated
    protected boolean isOuterSnapshotCompatible(S newSerializer) {
        return true;
    }

    protected OuterSchemaCompatibility resolveOuterSchemaCompatibility(S newSerializer) {
        return this.isOuterSnapshotCompatible(newSerializer) ? OuterSchemaCompatibility.COMPATIBLE_AS_IS : OuterSchemaCompatibility.INCOMPATIBLE;
    }

    private void internalWriteOuterSnapshot(DataOutputView out) throws IOException {
        out.writeInt(911108);
        out.writeInt(this.getCurrentOuterSnapshotVersion());
        this.writeOuterSnapshot(out);
    }

    private void internalReadOuterSnapshot(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != 911108) {
            throw new IOException(String.format("Corrupt data, magic number mismatch. Expected %8x, found %8x", 911108, magicNumber));
        }
        int outerSnapshotVersion = in.readInt();
        this.readOuterSnapshot(outerSnapshotVersion, in, userCodeClassLoader);
    }

    private void legacyInternalReadOuterSnapshot(int legacyReadVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.readOuterSnapshot(legacyReadVersion, in, userCodeClassLoader);
    }

    private TypeSerializerSchemaCompatibility<T> constructFinalSchemaCompatibilityResult(TypeSerializer<?>[] newNestedSerializers, TypeSerializerSnapshot<?>[] nestedSerializerSnapshots, OuterSchemaCompatibility outerSchemaCompatibility) {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult nestedSerializersCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult(newNestedSerializers, nestedSerializerSnapshots);
        if (outerSchemaCompatibility == OuterSchemaCompatibility.INCOMPATIBLE || nestedSerializersCompatibilityResult.isIncompatible()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        if (outerSchemaCompatibility == OuterSchemaCompatibility.COMPATIBLE_AFTER_MIGRATION || nestedSerializersCompatibilityResult.isCompatibleAfterMigration()) {
            return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
        }
        if (nestedSerializersCompatibilityResult.isCompatibleWithReconfiguredSerializer()) {
            S reconfiguredCompositeSerializer = this.createOuterSerializerWithNestedSerializers(nestedSerializersCompatibilityResult.getNestedSerializers());
            return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer(reconfiguredCompositeSerializer);
        }
        return TypeSerializerSchemaCompatibility.compatibleAsIs();
    }

    protected static enum OuterSchemaCompatibility {
        COMPATIBLE_AS_IS,
        COMPATIBLE_AFTER_MIGRATION,
        INCOMPATIBLE;

    }
}

